# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .open_aillm_model import OpenAillmModel


class OpenAillm(UniversalBaseModel):
    """
    OpenAI language model configuration
    """

    model: OpenAillmModel = pydantic.Field()
    """
    OpenAI model to use:
    - **gpt-4o**: Most capable, best for complex reasoning
    - **gpt-4o-mini**: Fast and cost-effective, good for most use cases
    - **gpt-3.5-turbo**: Legacy model, still capable
    - **o1**, **o3**: Advanced reasoning models
    - **gpt-4.1**: Latest GPT-4 variant with improved performance
    """

    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")] = pydantic.Field()
    """
    **Most Important Setting**: This defines your agent's personality, knowledge, and behavior.
    
    Write this as detailed instructions that include:
    - **Role**: Who is the agent? (receptionist, support agent, etc.)
    - **Personality**: Friendly, professional, casual, etc.
    - **Knowledge**: What does the agent know about?
    - **Tasks**: What can the agent help with?
    - **Guidelines**: How should it behave in different situations?
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
