# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class OrganizationStats(UniversalBaseModel):
    total_users: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="totalUsers")] = pydantic.Field(
        default=None
    )
    """
    Total number of users in the organization
    """

    active_users: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="activeUsers")] = (
        pydantic.Field(default=None)
    )
    """
    Number of active users
    """

    total_agents: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="totalAgents")] = (
        pydantic.Field(default=None)
    )
    """
    Total number of agents
    """

    total_phones: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="totalPhones")] = (
        pydantic.Field(default=None)
    )
    """
    Total number of phone numbers
    """

    total_assets: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="totalAssets")] = (
        pydantic.Field(default=None)
    )
    """
    Total number of knowledge assets
    """

    total_calls: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="totalCalls")] = pydantic.Field(
        default=None
    )
    """
    Total number of calls made
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
