# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .phone_agent import PhoneAgent


class Phone(UniversalBaseModel):
    pk_phone_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique phone identifier
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number in E.164 format
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone service provider
    """

    nickname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional friendly name for the phone
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the phone is currently active
    """

    fk_agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the assigned agent (if any)
    """

    fk_org_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    Organization that owns this phone
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Phone creation timestamp
    """

    agent: typing.Optional[PhoneAgent] = pydantic.Field(default=None)
    """
    Assigned agent details (if any)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
