# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tool_parameter import ToolParameter


class Tool(UniversalBaseModel):
    pk_tool_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique tool identifier
    """

    tool_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Tool name (used as function name in agent calls)
    """

    tool_description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of what the tool does
    """

    server_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API endpoint URL that will be called
    """

    parameters: typing.Optional[typing.List[ToolParameter]] = pydantic.Field(default=None)
    """
    Parameters that the tool accepts
    """

    created_at: typing.Optional[dt.datetime] = None
    fk_org_id: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
