# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class User(UniversalBaseModel):
    pk_user_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    User ID
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's email address
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's full name
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the user account is active
    """

    created_at: typing.Optional[dt.datetime] = None
    country: typing.Optional[str] = None
    rank: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
