# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class UserProfile(UniversalBaseModel):
    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    User ID
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's email address
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User's full name
    """

    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    Derived username from email
    """

    default_organization_id: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="defaultOrganizationId")
    ] = pydantic.Field(default=None)
    """
    User's primary organization ID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
