# mypy-boto3-redshift

[![PyPI - mypy-boto3-redshift](https://img.shields.io/pypi/v/mypy-boto3-redshift.svg?color=blue)](https://pypi.org/project/mypy-boto3-redshift)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-redshift.svg?color=blue)](https://pypi.org/project/mypy-boto3-redshift)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-redshift?color=blue)](https://pypistats.org/packages/mypy-boto3-redshift)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Redshift 1.17.63](https://boto3.amazonaws.com/v1/documentation/api/1.17.63/reference/services/redshift.html#Redshift)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-redshift docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_redshift/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-redshift](#mypy-boto3-redshift)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `Redshift` service.

```bash
python -m pip install boto3-stubs[redshift]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[redshift]` in your environment:
  `python -m pip install 'boto3-stubs[redshift]'`

Both type checking and auto-complete should work for `Redshift` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[redshift]` in your environment:
  `python -m pip install 'boto3-stubs[redshift]'`

Both type checking and auto-complete should work for `Redshift` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[redshift]` in your environment:
  `python -m pip install 'boto3-stubs[redshift]'`
- Run `mypy` as usual

Type checking should work for `Redshift` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[redshift]` in your environment:
  `python -m pip install 'boto3-stubs[redshift]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Redshift` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`RedshiftClient` provides annotations for `boto3.client("redshift")`.

```python
import boto3

from mypy_boto3_redshift import RedshiftClient

client: RedshiftClient = boto3.client("redshift")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RedshiftClient = session.client("redshift")
```

### Paginators annotations

`mypy_boto3_redshift.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_redshift import RedshiftClient
from mypy_boto3_redshift.paginator import (
    DescribeClusterDbRevisionsPaginator,
    DescribeClusterParameterGroupsPaginator,
    DescribeClusterParametersPaginator,
    DescribeClusterSecurityGroupsPaginator,
    DescribeClusterSnapshotsPaginator,
    DescribeClusterSubnetGroupsPaginator,
    DescribeClusterTracksPaginator,
    DescribeClusterVersionsPaginator,
    DescribeClustersPaginator,
    DescribeDefaultClusterParametersPaginator,
    DescribeEndpointAccessPaginator,
    DescribeEndpointAuthorizationPaginator,
    DescribeEventSubscriptionsPaginator,
    DescribeEventsPaginator,
    DescribeHsmClientCertificatesPaginator,
    DescribeHsmConfigurationsPaginator,
    DescribeNodeConfigurationOptionsPaginator,
    DescribeOrderableClusterOptionsPaginator,
    DescribeReservedNodeOfferingsPaginator,
    DescribeReservedNodesPaginator,
    DescribeScheduledActionsPaginator,
    DescribeSnapshotCopyGrantsPaginator,
    DescribeSnapshotSchedulesPaginator,
    DescribeTableRestoreStatusPaginator,
    DescribeTagsPaginator,
    DescribeUsageLimitsPaginator,
    GetReservedNodeExchangeOfferingsPaginator,
)

client: RedshiftClient = boto3.client("redshift")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_cluster_db_revisions_paginator: DescribeClusterDbRevisionsPaginator = client.get_paginator("describe_cluster_db_revisions")
describe_cluster_parameter_groups_paginator: DescribeClusterParameterGroupsPaginator = client.get_paginator("describe_cluster_parameter_groups")
describe_cluster_parameters_paginator: DescribeClusterParametersPaginator = client.get_paginator("describe_cluster_parameters")
describe_cluster_security_groups_paginator: DescribeClusterSecurityGroupsPaginator = client.get_paginator("describe_cluster_security_groups")
describe_cluster_snapshots_paginator: DescribeClusterSnapshotsPaginator = client.get_paginator("describe_cluster_snapshots")
describe_cluster_subnet_groups_paginator: DescribeClusterSubnetGroupsPaginator = client.get_paginator("describe_cluster_subnet_groups")
describe_cluster_tracks_paginator: DescribeClusterTracksPaginator = client.get_paginator("describe_cluster_tracks")
describe_cluster_versions_paginator: DescribeClusterVersionsPaginator = client.get_paginator("describe_cluster_versions")
describe_clusters_paginator: DescribeClustersPaginator = client.get_paginator("describe_clusters")
describe_default_cluster_parameters_paginator: DescribeDefaultClusterParametersPaginator = client.get_paginator("describe_default_cluster_parameters")
describe_endpoint_access_paginator: DescribeEndpointAccessPaginator = client.get_paginator("describe_endpoint_access")
describe_endpoint_authorization_paginator: DescribeEndpointAuthorizationPaginator = client.get_paginator("describe_endpoint_authorization")
describe_event_subscriptions_paginator: DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_hsm_client_certificates_paginator: DescribeHsmClientCertificatesPaginator = client.get_paginator("describe_hsm_client_certificates")
describe_hsm_configurations_paginator: DescribeHsmConfigurationsPaginator = client.get_paginator("describe_hsm_configurations")
describe_node_configuration_options_paginator: DescribeNodeConfigurationOptionsPaginator = client.get_paginator("describe_node_configuration_options")
describe_orderable_cluster_options_paginator: DescribeOrderableClusterOptionsPaginator = client.get_paginator("describe_orderable_cluster_options")
describe_reserved_node_offerings_paginator: DescribeReservedNodeOfferingsPaginator = client.get_paginator("describe_reserved_node_offerings")
describe_reserved_nodes_paginator: DescribeReservedNodesPaginator = client.get_paginator("describe_reserved_nodes")
describe_scheduled_actions_paginator: DescribeScheduledActionsPaginator = client.get_paginator("describe_scheduled_actions")
describe_snapshot_copy_grants_paginator: DescribeSnapshotCopyGrantsPaginator = client.get_paginator("describe_snapshot_copy_grants")
describe_snapshot_schedules_paginator: DescribeSnapshotSchedulesPaginator = client.get_paginator("describe_snapshot_schedules")
describe_table_restore_status_paginator: DescribeTableRestoreStatusPaginator = client.get_paginator("describe_table_restore_status")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_usage_limits_paginator: DescribeUsageLimitsPaginator = client.get_paginator("describe_usage_limits")
get_reserved_node_exchange_offerings_paginator: GetReservedNodeExchangeOfferingsPaginator = client.get_paginator("get_reserved_node_exchange_offerings")
```

### Waiters annotations

`mypy_boto3_redshift.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_redshift import RedshiftClient
from mypy_boto3_redshift.waiter import (
    ClusterAvailableWaiter,
    ClusterDeletedWaiter,
    ClusterRestoredWaiter,
    SnapshotAvailableWaiter,
)

client: RedshiftClient = boto3.client("redshift")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
cluster_available_waiter: ClusterAvailableWaiter = client.get_waiter("cluster_available")
cluster_deleted_waiter: ClusterDeletedWaiter = client.get_waiter("cluster_deleted")
cluster_restored_waiter: ClusterRestoredWaiter = client.get_waiter("cluster_restored")
snapshot_available_waiter: SnapshotAvailableWaiter = client.get_waiter("snapshot_available")
```

### Literals

`mypy_boto3_redshift.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_redshift.literals import (
    ActionType,
    AquaConfigurationStatus,
    AquaStatus,
    AuthorizationStatus,
    ClusterAvailableWaiterName,
    ClusterDeletedWaiterName,
    ClusterRestoredWaiterName,
    DescribeClusterDbRevisionsPaginatorName,
    DescribeClusterParameterGroupsPaginatorName,
    DescribeClusterParametersPaginatorName,
    DescribeClusterSecurityGroupsPaginatorName,
    DescribeClusterSnapshotsPaginatorName,
    DescribeClusterSubnetGroupsPaginatorName,
    DescribeClusterTracksPaginatorName,
    DescribeClusterVersionsPaginatorName,
    DescribeClustersPaginatorName,
    DescribeDefaultClusterParametersPaginatorName,
    DescribeEndpointAccessPaginatorName,
    DescribeEndpointAuthorizationPaginatorName,
    DescribeEventSubscriptionsPaginatorName,
    DescribeEventsPaginatorName,
    DescribeHsmClientCertificatesPaginatorName,
    DescribeHsmConfigurationsPaginatorName,
    DescribeNodeConfigurationOptionsPaginatorName,
    DescribeOrderableClusterOptionsPaginatorName,
    DescribeReservedNodeOfferingsPaginatorName,
    DescribeReservedNodesPaginatorName,
    DescribeScheduledActionsPaginatorName,
    DescribeSnapshotCopyGrantsPaginatorName,
    DescribeSnapshotSchedulesPaginatorName,
    DescribeTableRestoreStatusPaginatorName,
    DescribeTagsPaginatorName,
    DescribeUsageLimitsPaginatorName,
    GetReservedNodeExchangeOfferingsPaginatorName,
    Mode,
    NodeConfigurationOptionsFilterName,
    OperatorType,
    ParameterApplyType,
    PartnerIntegrationStatus,
    ReservedNodeOfferingType,
    ScheduleState,
    ScheduledActionFilterName,
    ScheduledActionState,
    ScheduledActionTypeValues,
    SnapshotAttributeToSortBy,
    SnapshotAvailableWaiterName,
    SortByOrder,
    SourceType,
    TableRestoreStatusType,
    UsageLimitBreachAction,
    UsageLimitFeatureType,
    UsageLimitLimitType,
    UsageLimitPeriod,
)

def check_value(value: ActionType) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_redshift.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_redshift.type_defs import (
    AcceptReservedNodeExchangeOutputMessageTypeDef,
    AccountAttributeListTypeDef,
    AccountAttributeTypeDef,
    AccountWithRestoreAccessTypeDef,
    AquaConfigurationTypeDef,
    AttributeValueTargetTypeDef,
    AuthorizeClusterSecurityGroupIngressResultTypeDef,
    AuthorizeSnapshotAccessResultTypeDef,
    AvailabilityZoneTypeDef,
    BatchDeleteClusterSnapshotsResultTypeDef,
    BatchModifyClusterSnapshotsOutputMessageTypeDef,
    ClusterAssociatedToScheduleTypeDef,
    ClusterCredentialsTypeDef,
    ClusterDbRevisionTypeDef,
    ClusterDbRevisionsMessageTypeDef,
    ClusterIamRoleTypeDef,
    ClusterNodeTypeDef,
    ClusterParameterGroupDetailsTypeDef,
    ClusterParameterGroupNameMessageTypeDef,
    ClusterParameterGroupStatusTypeDef,
    ClusterParameterGroupTypeDef,
    ClusterParameterGroupsMessageTypeDef,
    ClusterParameterStatusTypeDef,
    ClusterSecurityGroupMembershipTypeDef,
    ClusterSecurityGroupMessageTypeDef,
    ClusterSecurityGroupTypeDef,
    ClusterSnapshotCopyStatusTypeDef,
    ClusterSubnetGroupMessageTypeDef,
    ClusterSubnetGroupTypeDef,
    ClusterTypeDef,
    ClusterVersionTypeDef,
    ClusterVersionsMessageTypeDef,
    ClustersMessageTypeDef,
    CopyClusterSnapshotResultTypeDef,
    CreateClusterParameterGroupResultTypeDef,
    CreateClusterResultTypeDef,
    CreateClusterSecurityGroupResultTypeDef,
    CreateClusterSnapshotResultTypeDef,
    CreateClusterSubnetGroupResultTypeDef,
    CreateEventSubscriptionResultTypeDef,
    CreateHsmClientCertificateResultTypeDef,
    CreateHsmConfigurationResultTypeDef,
    CreateSnapshotCopyGrantResultTypeDef,
    CustomerStorageMessageTypeDef,
    DataTransferProgressTypeDef,
    DefaultClusterParametersTypeDef,
    DeferredMaintenanceWindowTypeDef,
    DeleteClusterResultTypeDef,
    DeleteClusterSnapshotMessageTypeDef,
    DeleteClusterSnapshotResultTypeDef,
    DescribeDefaultClusterParametersResultTypeDef,
    DescribePartnersOutputMessageTypeDef,
    DescribeSnapshotSchedulesOutputMessageTypeDef,
    DisableSnapshotCopyResultTypeDef,
    EC2SecurityGroupTypeDef,
    ElasticIpStatusTypeDef,
    EnableSnapshotCopyResultTypeDef,
    EndpointAccessListTypeDef,
    EndpointAccessTypeDef,
    EndpointAuthorizationListTypeDef,
    EndpointAuthorizationTypeDef,
    EndpointTypeDef,
    EventCategoriesMapTypeDef,
    EventCategoriesMessageTypeDef,
    EventInfoMapTypeDef,
    EventSubscriptionTypeDef,
    EventSubscriptionsMessageTypeDef,
    EventTypeDef,
    EventsMessageTypeDef,
    GetReservedNodeExchangeOfferingsOutputMessageTypeDef,
    HsmClientCertificateMessageTypeDef,
    HsmClientCertificateTypeDef,
    HsmConfigurationMessageTypeDef,
    HsmConfigurationTypeDef,
    HsmStatusTypeDef,
    IPRangeTypeDef,
    LoggingStatusTypeDef,
    MaintenanceTrackTypeDef,
    ModifyAquaOutputMessageTypeDef,
    ModifyClusterDbRevisionResultTypeDef,
    ModifyClusterIamRolesResultTypeDef,
    ModifyClusterMaintenanceResultTypeDef,
    ModifyClusterResultTypeDef,
    ModifyClusterSnapshotResultTypeDef,
    ModifyClusterSubnetGroupResultTypeDef,
    ModifyEventSubscriptionResultTypeDef,
    ModifySnapshotCopyRetentionPeriodResultTypeDef,
    NetworkInterfaceTypeDef,
    NodeConfigurationOptionTypeDef,
    NodeConfigurationOptionsFilterTypeDef,
    NodeConfigurationOptionsMessageTypeDef,
    OrderableClusterOptionTypeDef,
    OrderableClusterOptionsMessageTypeDef,
    PaginatorConfigTypeDef,
    ParameterTypeDef,
    PartnerIntegrationInfoTypeDef,
    PartnerIntegrationOutputMessageTypeDef,
    PauseClusterMessageTypeDef,
    PauseClusterResultTypeDef,
    PendingModifiedValuesTypeDef,
    PurchaseReservedNodeOfferingResultTypeDef,
    RebootClusterResultTypeDef,
    RecurringChargeTypeDef,
    ReservedNodeOfferingTypeDef,
    ReservedNodeOfferingsMessageTypeDef,
    ReservedNodeTypeDef,
    ReservedNodesMessageTypeDef,
    ResizeClusterMessageTypeDef,
    ResizeClusterResultTypeDef,
    ResizeInfoTypeDef,
    ResizeProgressMessageTypeDef,
    RestoreFromClusterSnapshotResultTypeDef,
    RestoreStatusTypeDef,
    RestoreTableFromClusterSnapshotResultTypeDef,
    ResumeClusterMessageTypeDef,
    ResumeClusterResultTypeDef,
    RevisionTargetTypeDef,
    RevokeClusterSecurityGroupIngressResultTypeDef,
    RevokeSnapshotAccessResultTypeDef,
    RotateEncryptionKeyResultTypeDef,
    ScheduledActionFilterTypeDef,
    ScheduledActionTypeDef,
    ScheduledActionTypeTypeDef,
    ScheduledActionsMessageTypeDef,
    SnapshotCopyGrantMessageTypeDef,
    SnapshotCopyGrantTypeDef,
    SnapshotErrorMessageTypeDef,
    SnapshotMessageTypeDef,
    SnapshotScheduleTypeDef,
    SnapshotSortingEntityTypeDef,
    SnapshotTypeDef,
    SubnetTypeDef,
    SupportedOperationTypeDef,
    SupportedPlatformTypeDef,
    TableRestoreStatusMessageTypeDef,
    TableRestoreStatusTypeDef,
    TagTypeDef,
    TaggedResourceListMessageTypeDef,
    TaggedResourceTypeDef,
    TrackListMessageTypeDef,
    UpdateTargetTypeDef,
    UsageLimitListTypeDef,
    UsageLimitTypeDef,
    VpcEndpointTypeDef,
    VpcSecurityGroupMembershipTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AcceptReservedNodeExchangeOutputMessageTypeDef:
    return {
      ...
    }
```
