# Amending Steps

Every step in StepUp can inform the director process of additional inputs
or environment variables it uses, or of additional (volatile) outputs it creates.
However, defining an amended input will fail
when that file is not yet built nor known as a static file.
In this case, the step wil exit early
and will be rescheduled by the director process when the amended input becomes available.

The [`amend()`][stepup.core.api.amend] function implements this feature
and is convenient in various scenarios:

- This is particularly useful when a step uses input files that refer to other input files.
  It may happen that some of these other input files still need to be generated by other steps.
  Once built, the other inputs may again refer to more input files, etc.
  Such dependencies cannot be discovered in advance,
  simply because not all inputs are available before running the steps that generate them.
  (This is a common scenario when writing LaTeX documents of which parts are generated by scripts.)

- Another use case is that some steps may take their default configuration
  from environment variables if some command-line options are missing.
  In this case, `amend()` can be used to specify the environment variables used.

- Some steps may produce a list of volatile outputs, some of which are difficult to know upfront.
  One may specify such volatile outputs with `amend()` after they have been created.

To use `amend()` effectively, use it as early as possible,
before accessing additional input files or creating unforeseen output files.
Also, try to amend as many possible step arguments in a single call.
This will avoid the following problems:

- Trying to read from a file that hasn't been created yet.

- Unintentionally overwriting a file, e.g. a STATIC file that you have written by hand.

- Performing unnecessary work
  (because a call to amend may mean that the step is interrupted and restarted later).
  This is particularly important when the step is time-consuming
  or when it uses `stepup.core.api` functions to extend the workflow.

- Rescheduling a step multiple times.

To the best of our knowledge, there is no equivalent of `amend()` in other build tools.
Some features in Ninja cover what can be achieved with `amend()`.

## Example

Example source files: [`docs/advanced_topics/amending_steps/`](https://github.com/reproducible-reporting/stepup-core/tree/main/docs/advanced_topics/amending_steps)

This example intentionally creates a simple scenario with an amended input.
This is a somewhat silly example to illustrate the concept.
You may achieve the same result without amending,
because you have full control over all scripts in the example.

Create the following `plan.py`,
where the first step is a script that will discover it needs an additional input.

```python
{% include 'advanced_topics/amending_steps/plan.py' %}
```

In addition, create a file `input.txt`
with some arbitrary contents and the following `step.py` script:

```python
{% include 'advanced_topics/amending_steps/step.py' %}
```

Make the scripts executable and fire up StepUp to see how it deals with the amended input:

```bash
chmod +x step.py plan.py
stepup boot -n 1
```

You should get the following terminal output:

```text
{% include 'advanced_topics/amending_steps/stdout.txt' %}
```

The output shows that `./step.py` first stops early due to the missing file `input.txt`.
Once this required input becomes clear,
StepUp schedules the optional step to generate the requested input.
Later, StepUp runs `./step.py` again.

## Try the Following

- Run StepUp again without making any changes.
  As expected, all steps are skipped.
  The `.stepup/graph.db` file also stores the amended information,
  so these don't need to be rediscovered later.

- Modify the `plan.py` file to include a second amended input, for example, `other.txt`.
  Run StepUp with these changes.
  Because `sources.txt` contains a new file, StepUp will try re-running
  `./step.py`, which will amend new inputs that require the step to be rescheduled again.
