# Optional Steps

By default, StepUp will build all steps.
As an exception, steps can be made optional by adding the `optional=True` option.
This is the opposite of most build tools, where steps are only executed when they are *targets*.

The reason for this difference is that conventional build tools work with rigid predefined graphs.
By accepting command-line arguments with target steps, they introduce some flexibility:
this lets the user control which part of the graph is executed.

StepUp offers such flexibility differently.
The basic premise is that all outdated or missing outputs need to be (re)built.
It is the responsibility of the build tool to figure out which steps need executing.
This responsibility should not be shifted to users by expecting them to specify targets.
That said, some legitimate exceptions exist, in which ignoring steps is a desirable feature.
These are supported by StepUp as follows:

- One can define **steps conditionally**, e.g.,
  as in the tutorial [Static Glob Conditional](../getting_started/static_glob_conditional.md).
  Such conditionals are controlled by external factors and
  are picked up by your `plan.py` without manual interventions.

- One can make **steps optional**, as in this tutorial.
  This is useful when multiple steps are defined in a loop,
  as in the [Static Glob](../getting_started/static_glob.md) tutorial,
  of which not all steps are required for the end result.
  Use this feature wisely:
  It is obviously inefficient to define a few thousand steps of which only a handful are needed.

- As shown in the [next tutorial](blocked_steps.md), one may also **block steps**,
  as a temporary measure to speed up the edit-build cycle.

Steps that define other steps, declare static files, or otherwise extend the workflow,
should not be made optional.
Until such steps are executed, StepUp has no idea what output these steps will generate,
which it would need to decide that an optional step is required by another step.

## Example

Example source files: [`docs/advanced_topics/optional_steps/`](https://github.com/reproducible-reporting/stepup-core/tree/main/docs/advanced_topics/optional_steps)

The example below uses the [`script()`][stepup.core.api.script] feature introduced in
[Script (Single Case)](../getting_started/script_single.md) and
[Script (Multiple Cases)](../getting_started/script_multiple.md)
to create a somewhat entertaining example.
However, practically all step-generating functions support the `optional` argument,
and can thus be made optional in the same way.

Create a first script `generate.py` that generates sequences
of the [logistic map](https://en.wikipedia.org/wiki/Logistic_map)
for different values of the parameter *r*:

```python
{% include 'advanced_topics/optional_steps/generate.py' %}
```

Then, write a `plot.py` script that plots only one of these sequences:

```python
{% include 'advanced_topics/optional_steps/plot.py' %}
```

The `plan.py` file adds steps for both scripts, but makes the data generation optional:

```python
{% include 'advanced_topics/optional_steps/plan.py' %}
```

Finally, make the scripts executable and run StepUp:

```bash
chmod +x generate.py plot.py plan.py
stepup boot -n 1
```

You should get the following output:

```text
{% include 'advanced_topics/optional_steps/stdout.txt' %}
```

Note that, in this case, it would be trivial to modify the `generate.py` script
to only generate the sequence of interest.
Whenever such a simpler approach is possible, it is always preferable.
However, in more complex use cases, it is not always possible
to figure out which steps are going to be needed or not.
In such situations, optional steps can be convenient.

## Try the Following

- Remove the `optional=True` keyword argument and rerun the plan.
  As expected, additional text files with sequences will be created.

- Restore the `optional=True` keyword argument and rerun the plan.
  As expected, the [Automatic Cleaning](../getting_started/automatic_cleaning.md) feature
  removes the outputs that were generated by steps that are no longer present in the workflow.
