#!/usr/bin/env python3
# Build + Upload su TestPyPI (se --test) oppure PyPI (default).
# Richiede: pip install build twine
# Usa ~/.pypirc per i token. Niente version bump, niente fronzoli.

import argparse
import shutil
import subprocess
import sys
from pathlib import Path

DIST = Path("dist")

def run(cmd: list[str]) -> None:
    print("·", " ".join(cmd))
    subprocess.run(cmd, check=True)

def main() -> None:
    ap = argparse.ArgumentParser(description="Build & upload package")
    ap.add_argument("--test", action="store_true", help="usa TestPyPI invece di PyPI")
    args = ap.parse_args()

    # pulisci dist/
    if DIST.exists():
        shutil.rmtree(DIST)

    # build (sdist + wheel)
    run([sys.executable, "-m", "build"])

    # upload
    repo = "testpypi" if args.test else "pypi"
    run([sys.executable, "-m", "twine", "upload", "--repository", repo, "dist/*"])

if __name__ == "__main__":
    main()