from typing import TypeVar, Generic, Optional

from pydantic import BaseModel

DataSuccess = TypeVar("DataSuccess")


class ApiInfoResponse(BaseModel):
    info: str = ""


class FailureData(BaseModel):
    title: str = ""
    msg: str = ""
    code: str = ""
    procedure: str = ""
    job: str = ""


class ApiResponse(BaseModel, Generic[DataSuccess]):
    error: Optional[FailureData] = None
    data: Optional[DataSuccess] = None
    info: ApiInfoResponse = ApiInfoResponse()


class Failure(Exception):
    def __init__(self, title: str = "", msg: str = "", code: str = "", *, procedure: str = "", job: str = ""):
        self.failure_data = FailureData(title=title, msg=msg, code=code, procedure=procedure, job=job)

    def __str__(self) -> str:
        f = self.failure_data
        return f"{f.title}: {f.msg} (Code: {f.code})"
