# mypy-boto3-iotsitewise

[![PyPI - mypy-boto3-iotsitewise](https://img.shields.io/pypi/v/mypy-boto3-iotsitewise.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotsitewise)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotsitewise.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotsitewise)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.IoTSiteWise 1.16.20](https://boto3.amazonaws.com/v1/documentation/api/1.16.20/reference/services/iotsitewise.html#IoTSiteWise) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-iotsitewise](#mypy-boto3-iotsitewise)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `IoTSiteWise` service.

```bash
python -m pip install boto3-stubs[iotsitewise]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotsitewise]` in your environment: `python -m pip install 'boto3-stubs[iotsitewise]'`

Both type checking and auto-complete should work for `IoTSiteWise` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[iotsitewise]` in your environment: `python -m pip install 'boto3-stubs[iotsitewise]'`

Both type checking and auto-complete should work for `IoTSiteWise` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotsitewise]` in your environment: `python -m pip install 'boto3-stubs[iotsitewise]'`
- Run `mypy` as usual

Type checking should work for `IoTSiteWise` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotsitewise]` in your environment: `python -m pip install 'boto3-stubs[iotsitewise]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTSiteWise` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoTSiteWiseClient` provides annotations for `boto3.client("iotsitewise")`.

```python
import boto3

from mypy_boto3_iotsitewise import IoTSiteWiseClient

client: IoTSiteWiseClient = boto3.client("iotsitewise")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTSiteWiseClient = session.client("iotsitewise")
```

### Paginators annotations

`mypy_boto3_iotsitewise.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iotsitewise import IoTSiteWiseClient
from mypy_boto3_iotsitewise.paginator import (
    GetAssetPropertyAggregatesPaginator,
    GetAssetPropertyValueHistoryPaginator,
    ListAccessPoliciesPaginator,
    ListAssetModelsPaginator,
    ListAssetsPaginator,
    ListAssociatedAssetsPaginator,
    ListDashboardsPaginator,
    ListGatewaysPaginator,
    ListPortalsPaginator,
    ListProjectAssetsPaginator,
    ListProjectsPaginator,
)

client: IoTSiteWiseClient = boto3.client("iotsitewise")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_asset_property_aggregates_paginator: GetAssetPropertyAggregatesPaginator = client.get_paginator("get_asset_property_aggregates")
get_asset_property_value_history_paginator: GetAssetPropertyValueHistoryPaginator = client.get_paginator("get_asset_property_value_history")
list_access_policies_paginator: ListAccessPoliciesPaginator = client.get_paginator("list_access_policies")
list_asset_models_paginator: ListAssetModelsPaginator = client.get_paginator("list_asset_models")
list_assets_paginator: ListAssetsPaginator = client.get_paginator("list_assets")
list_associated_assets_paginator: ListAssociatedAssetsPaginator = client.get_paginator("list_associated_assets")
list_dashboards_paginator: ListDashboardsPaginator = client.get_paginator("list_dashboards")
list_gateways_paginator: ListGatewaysPaginator = client.get_paginator("list_gateways")
list_portals_paginator: ListPortalsPaginator = client.get_paginator("list_portals")
list_project_assets_paginator: ListProjectAssetsPaginator = client.get_paginator("list_project_assets")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
```


### Waiters annotations

`mypy_boto3_iotsitewise.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_iotsitewise import IoTSiteWiseClient
from mypy_boto3_iotsitewise.waiter import (
    AssetActiveWaiter,
    AssetModelActiveWaiter,
    AssetModelNotExistsWaiter,
    AssetNotExistsWaiter,
    PortalActiveWaiter,
    PortalNotExistsWaiter,
)

client: IoTSiteWiseClient = boto3.client("iotsitewise")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
asset_active_waiter: AssetActiveWaiter = client.get_waiter("asset_active")
asset_model_active_waiter: AssetModelActiveWaiter = client.get_waiter("asset_model_active")
asset_model_not_exists_waiter: AssetModelNotExistsWaiter = client.get_waiter("asset_model_not_exists")
asset_not_exists_waiter: AssetNotExistsWaiter = client.get_waiter("asset_not_exists")
portal_active_waiter: PortalActiveWaiter = client.get_waiter("portal_active")
portal_not_exists_waiter: PortalNotExistsWaiter = client.get_waiter("portal_not_exists")
```





### Typed dictionations

`mypy_boto3_iotsitewise.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotsitewise.type_defs import (
    AccessPolicySummaryTypeDef,
    AggregatedValueTypeDef,
    AggregatesTypeDef,
    AssetErrorDetailsTypeDef,
    AssetHierarchyTypeDef,
    AssetModelHierarchyDefinitionTypeDef,
    AssetModelHierarchyTypeDef,
    AssetModelPropertyDefinitionTypeDef,
    AssetModelPropertyTypeDef,
    AssetModelStatusTypeDef,
    AssetModelSummaryTypeDef,
    AssetPropertyTypeDef,
    AssetPropertyValueTypeDef,
    AssetStatusTypeDef,
    AssetSummaryTypeDef,
    AssociatedAssetsSummaryTypeDef,
    AttributeTypeDef,
    BatchAssociateProjectAssetsResponseTypeDef,
    BatchDisassociateProjectAssetsResponseTypeDef,
    BatchPutAssetPropertyErrorEntryTypeDef,
    BatchPutAssetPropertyErrorTypeDef,
    BatchPutAssetPropertyValueResponseTypeDef,
    CreateAccessPolicyResponseTypeDef,
    CreateAssetModelResponseTypeDef,
    CreateAssetResponseTypeDef,
    CreateDashboardResponseTypeDef,
    CreateGatewayResponseTypeDef,
    CreatePortalResponseTypeDef,
    CreatePresignedPortalUrlResponseTypeDef,
    CreateProjectResponseTypeDef,
    DashboardSummaryTypeDef,
    DeleteAssetModelResponseTypeDef,
    DeleteAssetResponseTypeDef,
    DeletePortalResponseTypeDef,
    DescribeAccessPolicyResponseTypeDef,
    DescribeAssetModelResponseTypeDef,
    DescribeAssetPropertyResponseTypeDef,
    DescribeAssetResponseTypeDef,
    DescribeDashboardResponseTypeDef,
    DescribeGatewayCapabilityConfigurationResponseTypeDef,
    DescribeGatewayResponseTypeDef,
    DescribeLoggingOptionsResponseTypeDef,
    DescribePortalResponseTypeDef,
    DescribeProjectResponseTypeDef,
    ErrorDetailsTypeDef,
    ExpressionVariableTypeDef,
    GatewayCapabilitySummaryTypeDef,
    GatewayPlatformTypeDef,
    GatewaySummaryTypeDef,
    GetAssetPropertyAggregatesResponseTypeDef,
    GetAssetPropertyValueHistoryResponseTypeDef,
    GetAssetPropertyValueResponseTypeDef,
    GreengrassTypeDef,
    GroupIdentityTypeDef,
    IAMUserIdentityTypeDef,
    IdentityTypeDef,
    ImageFileTypeDef,
    ImageLocationTypeDef,
    ImageTypeDef,
    ListAccessPoliciesResponseTypeDef,
    ListAssetModelsResponseTypeDef,
    ListAssetsResponseTypeDef,
    ListAssociatedAssetsResponseTypeDef,
    ListDashboardsResponseTypeDef,
    ListGatewaysResponseTypeDef,
    ListPortalsResponseTypeDef,
    ListProjectAssetsResponseTypeDef,
    ListProjectsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    LoggingOptionsTypeDef,
    MetricTypeDef,
    MetricWindowTypeDef,
    MonitorErrorDetailsTypeDef,
    PaginatorConfigTypeDef,
    PortalResourceTypeDef,
    PortalStatusTypeDef,
    PortalSummaryTypeDef,
    ProjectResourceTypeDef,
    ProjectSummaryTypeDef,
    PropertyNotificationTypeDef,
    PropertyTypeDef,
    PropertyTypeTypeDef,
    PutAssetPropertyValueEntryTypeDef,
    ResourceTypeDef,
    TimeInNanosTypeDef,
    TransformTypeDef,
    TumblingWindowTypeDef,
    UpdateAssetModelResponseTypeDef,
    UpdateAssetResponseTypeDef,
    UpdateGatewayCapabilityConfigurationResponseTypeDef,
    UpdatePortalResponseTypeDef,
    UserIdentityTypeDef,
    VariableValueTypeDef,
    VariantTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccessPolicySummaryTypeDef:
    return {
      ...
    }
```
