# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCloudAccountResult',
    'AwaitableGetCloudAccountResult',
    'get_cloud_account',
    'get_cloud_account_output',
]

@pulumi.output_type
class GetCloudAccountResult:
    """
    A collection of values returned by getCloudAccount.
    """
    def __init__(__self__, account_id=None, cloud_provider=None, id=None, name=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> builtins.str:
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetCloudAccountResult(GetCloudAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAccountResult(
            account_id=self.account_id,
            cloud_provider=self.cloud_provider,
            id=self.id,
            name=self.name)


def get_cloud_account(account_id: Optional[builtins.str] = None,
                      cloud_provider: Optional[builtins.str] = None,
                      name: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAccountResult:
    """
    Use this data source to get information about a specific cloud account linked to New Relic.
    Accounts can be located by a combination of New Relic Account ID, name and cloud provider (aws, gcp, azure, etc). Name and cloud provider are required attributes. If no account_id is specified on the resource the provider level account_id will be used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    account = newrelic.get_cloud_account(account_id="12345",
        cloud_provider="aws",
        name="my aws account")
    ```


    :param builtins.str account_id: The account ID in New Relic.
    :param builtins.str cloud_provider: The cloud provider of the account (aws, gcp, azure, etc)
    :param builtins.str name: The cloud account name in New Relic.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['cloudProvider'] = cloud_provider
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:index/getCloudAccount:getCloudAccount', __args__, opts=opts, typ=GetCloudAccountResult).value

    return AwaitableGetCloudAccountResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        cloud_provider=pulumi.get(__ret__, 'cloud_provider'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_cloud_account_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             cloud_provider: Optional[pulumi.Input[builtins.str]] = None,
                             name: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAccountResult]:
    """
    Use this data source to get information about a specific cloud account linked to New Relic.
    Accounts can be located by a combination of New Relic Account ID, name and cloud provider (aws, gcp, azure, etc). Name and cloud provider are required attributes. If no account_id is specified on the resource the provider level account_id will be used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    account = newrelic.get_cloud_account(account_id="12345",
        cloud_provider="aws",
        name="my aws account")
    ```


    :param builtins.str account_id: The account ID in New Relic.
    :param builtins.str cloud_provider: The cloud provider of the account (aws, gcp, azure, etc)
    :param builtins.str name: The cloud account name in New Relic.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['cloudProvider'] = cloud_provider
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('newrelic:index/getCloudAccount:getCloudAccount', __args__, opts=opts, typ=GetCloudAccountResult)
    return __ret__.apply(lambda __response__: GetCloudAccountResult(
        account_id=pulumi.get(__response__, 'account_id'),
        cloud_provider=pulumi.get(__response__, 'cloud_provider'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
