# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorDowntimeArgs', 'MonitorDowntime']

@pulumi.input_type
class MonitorDowntimeArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[builtins.str],
                 mode: pulumi.Input[builtins.str],
                 start_time: pulumi.Input[builtins.str],
                 time_zone: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 end_repeat: Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']] = None,
                 frequency: Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']] = None,
                 maintenance_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 monitor_guids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MonitorDowntime resource.
        :param pulumi.Input[builtins.str] end_time: A datetime stamp signifying the end of the Monitor Downtime.
        :param pulumi.Input[builtins.str] mode: An identifier of the type of Monitor Downtime to be created.
        :param pulumi.Input[builtins.str] start_time: A datetime stamp signifying the start of the Monitor Downtime.
        :param pulumi.Input[builtins.str] time_zone: The timezone that applies to the Monitor Downtime schedule.
        :param pulumi.Input[builtins.str] account_id: The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
               provider{} configuration if not specified.
        :param pulumi.Input['MonitorDowntimeEndRepeatArgs'] end_repeat: A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        :param pulumi.Input['MonitorDowntimeFrequencyArgs'] frequency: Configuration options for which days of the month a monitor downtime will occur
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] maintenance_days: A list of maintenance days to be included with the created weekly Monitor Downtime.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] monitor_guids: A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        :param pulumi.Input[builtins.str] name: A name to identify the Monitor Downtime to be created.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_zone", time_zone)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if end_repeat is not None:
            pulumi.set(__self__, "end_repeat", end_repeat)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if maintenance_days is not None:
            pulumi.set(__self__, "maintenance_days", maintenance_days)
        if monitor_guids is not None:
            pulumi.set(__self__, "monitor_guids", monitor_guids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[builtins.str]:
        """
        A datetime stamp signifying the end of the Monitor Downtime.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        An identifier of the type of Monitor Downtime to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.str]:
        """
        A datetime stamp signifying the start of the Monitor Downtime.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[builtins.str]:
        """
        The timezone that applies to the Monitor Downtime schedule.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
        provider{} configuration if not specified.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="endRepeat")
    def end_repeat(self) -> Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']]:
        """
        A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        """
        return pulumi.get(self, "end_repeat")

    @end_repeat.setter
    def end_repeat(self, value: Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']]):
        pulumi.set(self, "end_repeat", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']]:
        """
        Configuration options for which days of the month a monitor downtime will occur
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="maintenanceDays")
    def maintenance_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of maintenance days to be included with the created weekly Monitor Downtime.
        """
        return pulumi.get(self, "maintenance_days")

    @maintenance_days.setter
    def maintenance_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "maintenance_days", value)

    @property
    @pulumi.getter(name="monitorGuids")
    def monitor_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        """
        return pulumi.get(self, "monitor_guids")

    @monitor_guids.setter
    def monitor_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "monitor_guids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name to identify the Monitor Downtime to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MonitorDowntimeState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 end_repeat: Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']] = None,
                 maintenance_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_guids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitorDowntime resources.
        :param pulumi.Input[builtins.str] account_id: The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
               provider{} configuration if not specified.
        :param pulumi.Input['MonitorDowntimeEndRepeatArgs'] end_repeat: A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        :param pulumi.Input[builtins.str] end_time: A datetime stamp signifying the end of the Monitor Downtime.
        :param pulumi.Input['MonitorDowntimeFrequencyArgs'] frequency: Configuration options for which days of the month a monitor downtime will occur
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] maintenance_days: A list of maintenance days to be included with the created weekly Monitor Downtime.
        :param pulumi.Input[builtins.str] mode: An identifier of the type of Monitor Downtime to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] monitor_guids: A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        :param pulumi.Input[builtins.str] name: A name to identify the Monitor Downtime to be created.
        :param pulumi.Input[builtins.str] start_time: A datetime stamp signifying the start of the Monitor Downtime.
        :param pulumi.Input[builtins.str] time_zone: The timezone that applies to the Monitor Downtime schedule.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if end_repeat is not None:
            pulumi.set(__self__, "end_repeat", end_repeat)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if maintenance_days is not None:
            pulumi.set(__self__, "maintenance_days", maintenance_days)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if monitor_guids is not None:
            pulumi.set(__self__, "monitor_guids", monitor_guids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
        provider{} configuration if not specified.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="endRepeat")
    def end_repeat(self) -> Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']]:
        """
        A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        """
        return pulumi.get(self, "end_repeat")

    @end_repeat.setter
    def end_repeat(self, value: Optional[pulumi.Input['MonitorDowntimeEndRepeatArgs']]):
        pulumi.set(self, "end_repeat", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A datetime stamp signifying the end of the Monitor Downtime.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']]:
        """
        Configuration options for which days of the month a monitor downtime will occur
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input['MonitorDowntimeFrequencyArgs']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="maintenanceDays")
    def maintenance_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of maintenance days to be included with the created weekly Monitor Downtime.
        """
        return pulumi.get(self, "maintenance_days")

    @maintenance_days.setter
    def maintenance_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "maintenance_days", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identifier of the type of Monitor Downtime to be created.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="monitorGuids")
    def monitor_guids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        """
        return pulumi.get(self, "monitor_guids")

    @monitor_guids.setter
    def monitor_guids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "monitor_guids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name to identify the Monitor Downtime to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A datetime stamp signifying the start of the Monitor Downtime.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timezone that applies to the Monitor Downtime schedule.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("newrelic:index/monitorDowntime:MonitorDowntime")
class MonitorDowntime(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 end_repeat: Optional[pulumi.Input[Union['MonitorDowntimeEndRepeatArgs', 'MonitorDowntimeEndRepeatArgsDict']]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[Union['MonitorDowntimeFrequencyArgs', 'MonitorDowntimeFrequencyArgsDict']]] = None,
                 maintenance_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_guids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to create, update, and delete [Monitor Downtimes](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/using-monitors/monitor-downtimes-disable-monitoring-during-scheduled-maintenance-times/) in New Relic.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.MonitorDowntime("foo",
            name="Sample Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="WEEKLY",
            start_time="2023-11-30T10:30:00",
            end_time="2023-12-10T02:45:30",
            time_zone="Asia/Kolkata",
            end_repeat={
                "on_date": "2023-12-20",
            },
            maintenance_days=[
                "FRIDAY",
                "SATURDAY",
            ])
        ```
        Monitor Downtimes are of four types; **one-time**, **daily**, **weekly** and **monthly**. For more details on each type and the right arguments that go with them, check out the argument reference and examples sections below.

        ## Examples

        ### One-Time Monitor Downtime

        The below example illustrates creating a **one-time** monitor downtime.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_one_time_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_one_time_newrelic_monitor_downtime",
            name="Sample One Time Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="ONE_TIME",
            start_time="2023-12-04T10:15:00",
            end_time="2024-01-04T16:24:30",
            time_zone="America/Los_Angeles")
        ```

        ### Daily Monitor Downtime

        The below example illustrates creating a **daily** monitor downtime.

        Note that `end_repeat` has been specified in the configuration; however, this is optional, in accordance with the rules of `end_repeat` specified in the argument reference section above. This example uses the `on_date` nested argument of `end_repeat`, however, the other nested argument, `on_repeat` may also be used _instead_, as you may see in some of the other examples below; though both `on_date` and `on_repeat` cannot be specified together, as they are mutually exclusive.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_daily_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_daily_newrelic_monitor_downtime",
            name="Sample Daily Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="DAILY",
            start_time="2023-12-04T18:15:00",
            end_time="2024-01-04T07:15:00",
            end_repeat={
                "on_date": "2023-12-25",
            },
            time_zone="Asia/Kolkata")
        ```

        ### Weekly Monitor Downtime

        The below example illustrates creating a **weekly** monitor downtime.

        Note that `maintenance_days` has been specified in the configuration as it is required with weekly monitor downtimes; and `end_repeat` has not been specified as it is optional, all in accordance with the rules of these arguments specified in the argument reference section above.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_weekly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_weekly_newrelic_monitor_downtime",
            name="Sample Weekly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="WEEKLY",
            start_time="2023-12-04T14:15:00",
            end_time="2024-01-04T23:55:00",
            time_zone="US/Hawaii",
            maintenance_days=[
                "SATURDAY",
                "SUNDAY",
            ])
        ```

        ### Monthly Monitor Downtime

        The below example illustrates creating a **monthly** monitor downtime.

        Note that `frequency` has been specified in the configuration as it is required with monthly monitor downtimes, and `end_repeat` has been specified too, though it is optional. `frequency` has been specified with `days_of_week` comprising both of its nested arguments, `ordinal_day_of_month` and `week_day`; all in accordance with the rules of these arguments specified in the argument reference section above.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_monthly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_monthly_newrelic_monitor_downtime",
            name="Sample Monthly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="MONTHLY",
            start_time="2023-12-04T07:15:00",
            end_time="2024-01-04T19:15:00",
            end_repeat={
                "on_repeat": 6,
            },
            time_zone="Europe/Dublin",
            frequency={
                "days_of_week": {
                    "ordinal_day_of_month": "SECOND",
                    "week_day": "SATURDAY",
                },
            })
        ```
        However, the `frequency` block in monthly monitor downtimes may also be specified with its other nested argument, `days_of_month`, as shown in the example below - though both `days_of_month` and `days_of_week` cannot be specified together, as they are mutually exclusive.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_monthly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_monthly_newrelic_monitor_downtime",
            name="Sample Monthly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="MONTHLY",
            start_time="2023-12-04T07:15:00",
            end_time="2024-01-04T19:15:00",
            end_repeat={
                "on_repeat": 6,
            },
            time_zone="Europe/Dublin",
            frequency={
                "days_of_months": [
                    3,
                    6,
                    14,
                    23,
                ],
            })
        ```

        ## Import

        A monitor downtime can be imported into Terraform configuration using its `guid`, i.e.

        bash

        ```sh
        $ pulumi import newrelic:index/monitorDowntime:MonitorDowntime monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
               provider{} configuration if not specified.
        :param pulumi.Input[Union['MonitorDowntimeEndRepeatArgs', 'MonitorDowntimeEndRepeatArgsDict']] end_repeat: A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        :param pulumi.Input[builtins.str] end_time: A datetime stamp signifying the end of the Monitor Downtime.
        :param pulumi.Input[Union['MonitorDowntimeFrequencyArgs', 'MonitorDowntimeFrequencyArgsDict']] frequency: Configuration options for which days of the month a monitor downtime will occur
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] maintenance_days: A list of maintenance days to be included with the created weekly Monitor Downtime.
        :param pulumi.Input[builtins.str] mode: An identifier of the type of Monitor Downtime to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] monitor_guids: A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        :param pulumi.Input[builtins.str] name: A name to identify the Monitor Downtime to be created.
        :param pulumi.Input[builtins.str] start_time: A datetime stamp signifying the start of the Monitor Downtime.
        :param pulumi.Input[builtins.str] time_zone: The timezone that applies to the Monitor Downtime schedule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorDowntimeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to create, update, and delete [Monitor Downtimes](https://docs.newrelic.com/docs/synthetics/synthetic-monitoring/using-monitors/monitor-downtimes-disable-monitoring-during-scheduled-maintenance-times/) in New Relic.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        foo = newrelic.MonitorDowntime("foo",
            name="Sample Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="WEEKLY",
            start_time="2023-11-30T10:30:00",
            end_time="2023-12-10T02:45:30",
            time_zone="Asia/Kolkata",
            end_repeat={
                "on_date": "2023-12-20",
            },
            maintenance_days=[
                "FRIDAY",
                "SATURDAY",
            ])
        ```
        Monitor Downtimes are of four types; **one-time**, **daily**, **weekly** and **monthly**. For more details on each type and the right arguments that go with them, check out the argument reference and examples sections below.

        ## Examples

        ### One-Time Monitor Downtime

        The below example illustrates creating a **one-time** monitor downtime.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_one_time_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_one_time_newrelic_monitor_downtime",
            name="Sample One Time Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="ONE_TIME",
            start_time="2023-12-04T10:15:00",
            end_time="2024-01-04T16:24:30",
            time_zone="America/Los_Angeles")
        ```

        ### Daily Monitor Downtime

        The below example illustrates creating a **daily** monitor downtime.

        Note that `end_repeat` has been specified in the configuration; however, this is optional, in accordance with the rules of `end_repeat` specified in the argument reference section above. This example uses the `on_date` nested argument of `end_repeat`, however, the other nested argument, `on_repeat` may also be used _instead_, as you may see in some of the other examples below; though both `on_date` and `on_repeat` cannot be specified together, as they are mutually exclusive.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_daily_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_daily_newrelic_monitor_downtime",
            name="Sample Daily Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="DAILY",
            start_time="2023-12-04T18:15:00",
            end_time="2024-01-04T07:15:00",
            end_repeat={
                "on_date": "2023-12-25",
            },
            time_zone="Asia/Kolkata")
        ```

        ### Weekly Monitor Downtime

        The below example illustrates creating a **weekly** monitor downtime.

        Note that `maintenance_days` has been specified in the configuration as it is required with weekly monitor downtimes; and `end_repeat` has not been specified as it is optional, all in accordance with the rules of these arguments specified in the argument reference section above.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_weekly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_weekly_newrelic_monitor_downtime",
            name="Sample Weekly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="WEEKLY",
            start_time="2023-12-04T14:15:00",
            end_time="2024-01-04T23:55:00",
            time_zone="US/Hawaii",
            maintenance_days=[
                "SATURDAY",
                "SUNDAY",
            ])
        ```

        ### Monthly Monitor Downtime

        The below example illustrates creating a **monthly** monitor downtime.

        Note that `frequency` has been specified in the configuration as it is required with monthly monitor downtimes, and `end_repeat` has been specified too, though it is optional. `frequency` has been specified with `days_of_week` comprising both of its nested arguments, `ordinal_day_of_month` and `week_day`; all in accordance with the rules of these arguments specified in the argument reference section above.

        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_monthly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_monthly_newrelic_monitor_downtime",
            name="Sample Monthly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="MONTHLY",
            start_time="2023-12-04T07:15:00",
            end_time="2024-01-04T19:15:00",
            end_repeat={
                "on_repeat": 6,
            },
            time_zone="Europe/Dublin",
            frequency={
                "days_of_week": {
                    "ordinal_day_of_month": "SECOND",
                    "week_day": "SATURDAY",
                },
            })
        ```
        However, the `frequency` block in monthly monitor downtimes may also be specified with its other nested argument, `days_of_month`, as shown in the example below - though both `days_of_month` and `days_of_week` cannot be specified together, as they are mutually exclusive.
        ```python
        import pulumi
        import pulumi_newrelic as newrelic

        sample_monthly_newrelic_monitor_downtime = newrelic.MonitorDowntime("sample_monthly_newrelic_monitor_downtime",
            name="Sample Monthly Monitor Downtime",
            monitor_guids=[
                "<GUID-1>",
                "<GUID-2>",
            ],
            mode="MONTHLY",
            start_time="2023-12-04T07:15:00",
            end_time="2024-01-04T19:15:00",
            end_repeat={
                "on_repeat": 6,
            },
            time_zone="Europe/Dublin",
            frequency={
                "days_of_months": [
                    3,
                    6,
                    14,
                    23,
                ],
            })
        ```

        ## Import

        A monitor downtime can be imported into Terraform configuration using its `guid`, i.e.

        bash

        ```sh
        $ pulumi import newrelic:index/monitorDowntime:MonitorDowntime monitor <guid>
        ```

        :param str resource_name: The name of the resource.
        :param MonitorDowntimeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorDowntimeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 end_repeat: Optional[pulumi.Input[Union['MonitorDowntimeEndRepeatArgs', 'MonitorDowntimeEndRepeatArgsDict']]] = None,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[Union['MonitorDowntimeFrequencyArgs', 'MonitorDowntimeFrequencyArgsDict']]] = None,
                 maintenance_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_guids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorDowntimeArgs.__new__(MonitorDowntimeArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["end_repeat"] = end_repeat
            if end_time is None and not opts.urn:
                raise TypeError("Missing required property 'end_time'")
            __props__.__dict__["end_time"] = end_time
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["maintenance_days"] = maintenance_days
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["monitor_guids"] = monitor_guids
            __props__.__dict__["name"] = name
            if start_time is None and not opts.urn:
                raise TypeError("Missing required property 'start_time'")
            __props__.__dict__["start_time"] = start_time
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
        super(MonitorDowntime, __self__).__init__(
            'newrelic:index/monitorDowntime:MonitorDowntime',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            end_repeat: Optional[pulumi.Input[Union['MonitorDowntimeEndRepeatArgs', 'MonitorDowntimeEndRepeatArgsDict']]] = None,
            end_time: Optional[pulumi.Input[builtins.str]] = None,
            frequency: Optional[pulumi.Input[Union['MonitorDowntimeFrequencyArgs', 'MonitorDowntimeFrequencyArgsDict']]] = None,
            maintenance_days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            monitor_guids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            start_time: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None) -> 'MonitorDowntime':
        """
        Get an existing MonitorDowntime resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
               provider{} configuration if not specified.
        :param pulumi.Input[Union['MonitorDowntimeEndRepeatArgs', 'MonitorDowntimeEndRepeatArgsDict']] end_repeat: A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        :param pulumi.Input[builtins.str] end_time: A datetime stamp signifying the end of the Monitor Downtime.
        :param pulumi.Input[Union['MonitorDowntimeFrequencyArgs', 'MonitorDowntimeFrequencyArgsDict']] frequency: Configuration options for which days of the month a monitor downtime will occur
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] maintenance_days: A list of maintenance days to be included with the created weekly Monitor Downtime.
        :param pulumi.Input[builtins.str] mode: An identifier of the type of Monitor Downtime to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] monitor_guids: A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        :param pulumi.Input[builtins.str] name: A name to identify the Monitor Downtime to be created.
        :param pulumi.Input[builtins.str] start_time: A datetime stamp signifying the start of the Monitor Downtime.
        :param pulumi.Input[builtins.str] time_zone: The timezone that applies to the Monitor Downtime schedule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorDowntimeState.__new__(_MonitorDowntimeState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["end_repeat"] = end_repeat
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["maintenance_days"] = maintenance_days
        __props__.__dict__["mode"] = mode
        __props__.__dict__["monitor_guids"] = monitor_guids
        __props__.__dict__["name"] = name
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["time_zone"] = time_zone
        return MonitorDowntime(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the New Relic account in which the Monitor Downtime shall be created. Defaults to the `account_id` in the
        provider{} configuration if not specified.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="endRepeat")
    def end_repeat(self) -> pulumi.Output[Optional['outputs.MonitorDowntimeEndRepeat']]:
        """
        A specification of when the Monitor Downtime should end its repeat cycle, by number of occurrences or date.
        """
        return pulumi.get(self, "end_repeat")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[builtins.str]:
        """
        A datetime stamp signifying the end of the Monitor Downtime.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional['outputs.MonitorDowntimeFrequency']]:
        """
        Configuration options for which days of the month a monitor downtime will occur
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="maintenanceDays")
    def maintenance_days(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of maintenance days to be included with the created weekly Monitor Downtime.
        """
        return pulumi.get(self, "maintenance_days")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        An identifier of the type of Monitor Downtime to be created.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="monitorGuids")
    def monitor_guids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of GUIDs of monitors, to which the created Monitor Downtime shall be applied.
        """
        return pulumi.get(self, "monitor_guids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name to identify the Monitor Downtime to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[builtins.str]:
        """
        A datetime stamp signifying the start of the Monitor Downtime.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        The timezone that applies to the Monitor Downtime schedule.
        """
        return pulumi.get(self, "time_zone")

