from dataclasses import dataclass
from typing import Any, ClassVar, Protocol, Self, runtime_checkable

from funcy_bear.context.di import DeclarativeContainer

@dataclass(slots=True)
class Result:
    exception: Exception | None = None
    instance: Any | None = None
    success: bool = True

    def successful(self, instance: Any) -> Self: ...
    def fail(self, e: Exception) -> Self: ...
    @property
    def error(self) -> str: ...

@runtime_checkable
class Provider[T: DeclarativeContainer](Protocol):
    _container: ClassVar[type[DeclarativeContainer] | DeclarativeContainer]

    service_name: str
    result: Result
    container: type[T] | T

    @classmethod
    def has_container(cls) -> bool: ...
    @classmethod
    def set_container(cls, container: type[T] | T) -> None: ...
    @classmethod
    def get_container(cls) -> type[T]: ...
    def __new__(cls, *args: Any, **kwargs: Any) -> Self: ...
    def __init__(self, service_name: str, container: type[T] | T) -> None: ...
    def __call__(self, *args, **kwargs) -> Self: ...
    def __getattr__(self, item: str) -> Self: ...
    def __getitem__(self, item: Any) -> Any: ...
    def __class_getitem__(cls, item: Any) -> Self: ...

Provide: Provider
