from typing import Any, NoReturn, TypedDict, overload

from funcy_bear.type_stuffs.constants import NoReturnCall

type FreezableTypes = dict | list | set
type ThawTypes = FrozenDict | tuple | frozenset

class FrozenDict(dict):
    def _immutable(self, *args, **kws) -> NoReturn: ...
    clear: NoReturnCall = ...
    setdefault: NoReturnCall = ...  # type: ignore[override]
    popitem: NoReturnCall = ...
    update: NoReturnCall = ...  # type: ignore[override]
    pop: NoReturnCall = ...  # type: ignore[override]
    __setitem__: NoReturnCall = ...
    __delitem__: NoReturnCall = ...
    def __hash__(self) -> int: ...  # type: ignore[override]

@overload
def freeze(obj: dict) -> FrozenDict: ...
@overload
def freeze(obj: TypedDict) -> FrozenDict: ...  # type: ignore[misc]
@overload
def freeze(obj: list) -> tuple: ...
@overload
def freeze(obj: set) -> frozenset: ...
@overload
def freeze(obj: object) -> object: ...
def freeze(obj: FreezableTypes | object) -> FrozenDict | tuple | frozenset | object: ...
@overload
def thaw(obj: FrozenDict) -> dict: ...
@overload
def thaw(obj: tuple) -> list: ...
@overload
def thaw(obj: frozenset) -> set: ...
@overload
def thaw(obj: Any) -> Any: ...
def thaw(obj: ThawTypes | Any) -> FreezableTypes: ...
