from setuptools import find_packages, setup

setup(
    name='mathstrovehiclesim',
    version='2.0.7',
    description='A short description of your package',
    author='Richard Hamilton',
    author_email='r.hamilton@mathstronauts.ca',
    url='https://github.com/your_username/your_package_name',
    include_package_data=True,
    package_data={'': ['images/*',
                       'images/traffic_signs/headlights-off/*',
                       'images/traffic_signs/headlights-on/*',
                       'images/traffic_signs/keep-left/*',
                       'images/traffic_signs/keep-right/*',
                       'images/traffic_signs/school-zone/*',
                       'images/traffic_signs/speed-limit/*',
                       'images/traffic_signs/stop/*',
                       'demo_images/shapes/*',
                       'demo_images/actions/*',
                       'demo_images/actions/disappear/*',
                       'demo_images/actions/distort/*',
                       'demo_images/actions/shrink/*',
                       'demo_images/actions/squeeze/*',
                       'demo_images/actions/squish/*',
                       'demo_images/actions/stretch/*',
                       'simulation_cfg.json']},
    packages=find_packages(),
    install_requires=[
        "pygame",
        "easydict",
        "pandas==1.3.5",
    ],
    extras_require={
        "dev": [
            "black>=23.1a1",
            "flake8>=3.8.4",
            "pytest>=6.2.5",
            "pytest-cov>=2.11.1",
            "isort>=5.7.0",
            "pre-commit>=2.9.3",
            "ipython>=8.8.0",
            "ipykernel>=6.20.2",
            "ipywidgets>=7.6.3",
            "build",
            "twine",
            "pandas==1.3.5",
            "mathstropy==4.0.4"
        ]
    },
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
