<a id="mypy-boto3-amplify"></a>

# mypy-boto3-amplify

[![PyPI - mypy-boto3-amplify](https://img.shields.io/pypi/v/mypy-boto3-amplify.svg?color=blue)](https://pypi.org/project/mypy-boto3-amplify)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-amplify.svg?color=blue)](https://pypi.org/project/mypy-boto3-amplify)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-amplify?color=blue)](https://pypistats.org/packages/mypy-boto3-amplify)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Amplify 1.18.38](https://boto3.amazonaws.com/v1/documentation/api/1.18.38/reference/services/amplify.html#Amplify)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-amplify docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_amplify/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-amplify](#mypy-boto3-amplify)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Amplify` service.

```bash
python -m pip install boto3-stubs[amplify]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[amplify]` in your environment:
  `python -m pip install 'boto3-stubs[amplify]'`

Both type checking and auto-complete should work for `Amplify` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[amplify]` in your environment:
  `python -m pip install 'boto3-stubs[amplify]'`

Both type checking and auto-complete should work for `Amplify` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[amplify]` in your environment:
  `python -m pip install 'boto3-stubs[amplify]'`
- Run `mypy` as usual

Type checking should work for `Amplify` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[amplify]` in your environment:
  `python -m pip install 'boto3-stubs[amplify]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Amplify` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`AmplifyClient` provides annotations for `boto3.client("amplify")`.

```python
import boto3

from mypy_boto3_amplify import AmplifyClient

client: AmplifyClient = boto3.client("amplify")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AmplifyClient = session.client("amplify")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_amplify.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_amplify import AmplifyClient
from mypy_boto3_amplify.paginator import (
    ListAppsPaginator,
    ListBranchesPaginator,
    ListDomainAssociationsPaginator,
    ListJobsPaginator,
)

client: AmplifyClient = boto3.client("amplify")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_apps_paginator: ListAppsPaginator = client.get_paginator("list_apps")
list_branches_paginator: ListBranchesPaginator = client.get_paginator("list_branches")
list_domain_associations_paginator: ListDomainAssociationsPaginator = client.get_paginator("list_domain_associations")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
```

<a id="literals"></a>

### Literals

`mypy_boto3_amplify.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_amplify.literals import (
    DomainStatusType,
    JobStatusType,
    JobTypeType,
    ListAppsPaginatorName,
    ListBranchesPaginatorName,
    ListDomainAssociationsPaginatorName,
    ListJobsPaginatorName,
    PlatformType,
    StageType,
)

def check_value(value: DomainStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_amplify.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_amplify.type_defs import (
    AppTypeDef,
    ArtifactTypeDef,
    AutoBranchCreationConfigTypeDef,
    BackendEnvironmentTypeDef,
    BranchTypeDef,
    CreateAppRequestRequestTypeDef,
    CreateAppResultTypeDef,
    CreateBackendEnvironmentRequestRequestTypeDef,
    CreateBackendEnvironmentResultTypeDef,
    CreateBranchRequestRequestTypeDef,
    CreateBranchResultTypeDef,
    CreateDeploymentRequestRequestTypeDef,
    CreateDeploymentResultTypeDef,
    CreateDomainAssociationRequestRequestTypeDef,
    CreateDomainAssociationResultTypeDef,
    CreateWebhookRequestRequestTypeDef,
    CreateWebhookResultTypeDef,
    CustomRuleTypeDef,
    DeleteAppRequestRequestTypeDef,
    DeleteAppResultTypeDef,
    DeleteBackendEnvironmentRequestRequestTypeDef,
    DeleteBackendEnvironmentResultTypeDef,
    DeleteBranchRequestRequestTypeDef,
    DeleteBranchResultTypeDef,
    DeleteDomainAssociationRequestRequestTypeDef,
    DeleteDomainAssociationResultTypeDef,
    DeleteJobRequestRequestTypeDef,
    DeleteJobResultTypeDef,
    DeleteWebhookRequestRequestTypeDef,
    DeleteWebhookResultTypeDef,
    DomainAssociationTypeDef,
    GenerateAccessLogsRequestRequestTypeDef,
    GenerateAccessLogsResultTypeDef,
    GetAppRequestRequestTypeDef,
    GetAppResultTypeDef,
    GetArtifactUrlRequestRequestTypeDef,
    GetArtifactUrlResultTypeDef,
    GetBackendEnvironmentRequestRequestTypeDef,
    GetBackendEnvironmentResultTypeDef,
    GetBranchRequestRequestTypeDef,
    GetBranchResultTypeDef,
    GetDomainAssociationRequestRequestTypeDef,
    GetDomainAssociationResultTypeDef,
    GetJobRequestRequestTypeDef,
    GetJobResultTypeDef,
    GetWebhookRequestRequestTypeDef,
    GetWebhookResultTypeDef,
    JobSummaryTypeDef,
    JobTypeDef,
    ListAppsRequestRequestTypeDef,
    ListAppsResultTypeDef,
    ListArtifactsRequestRequestTypeDef,
    ListArtifactsResultTypeDef,
    ListBackendEnvironmentsRequestRequestTypeDef,
    ListBackendEnvironmentsResultTypeDef,
    ListBranchesRequestRequestTypeDef,
    ListBranchesResultTypeDef,
    ListDomainAssociationsRequestRequestTypeDef,
    ListDomainAssociationsResultTypeDef,
    ListJobsRequestRequestTypeDef,
    ListJobsResultTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebhooksRequestRequestTypeDef,
    ListWebhooksResultTypeDef,
    PaginatorConfigTypeDef,
    ProductionBranchTypeDef,
    ResponseMetadataTypeDef,
    StartDeploymentRequestRequestTypeDef,
    StartDeploymentResultTypeDef,
    StartJobRequestRequestTypeDef,
    StartJobResultTypeDef,
    StepTypeDef,
    StopJobRequestRequestTypeDef,
    StopJobResultTypeDef,
    SubDomainSettingTypeDef,
    SubDomainTypeDef,
    TagResourceRequestRequestTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAppRequestRequestTypeDef,
    UpdateAppResultTypeDef,
    UpdateBranchRequestRequestTypeDef,
    UpdateBranchResultTypeDef,
    UpdateDomainAssociationRequestRequestTypeDef,
    UpdateDomainAssociationResultTypeDef,
    UpdateWebhookRequestRequestTypeDef,
    UpdateWebhookResultTypeDef,
    WebhookTypeDef,
)

def get_structure() -> AppTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-amplify` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-amplify docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_amplify/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
