import re
from setuptools import setup, find_packages

long_description = """
GUI wrapper for pdf.
"""

# Retrieve version number
VERSIONFILE = "pdf/gui/_version.py"
verstrline = open(VERSIONFILE, "rt").read()
VSRE = r"^__version__ = ['\"]([^'\"]*)['\"]"
mo = re.search(VSRE, verstrline, re.M)
if mo:
    verstr = mo.group(1)
else:
    raise RuntimeError("Unable to find version string in %s." % (VERSIONFILE))

setup(
    install_requires=[
        'pdfconduit',
    ],
    name='pdfconduit-gui',
    version=verstr,
    packages=find_packages(),
    namespace_packages=['pdf'],
    include_package_data=True,
    url='https://github.com/mrstephenneal/pdfconduit',
    license='',
    author='Stephen Neal',
    author_email='stephen@stephenneal.net',
    description='GUI wrapper for pdfconduit.',
    long_description=long_description,
)

