"""
recreate time_sku_features table

Revision ID: 1541fb9cfe23
Revises: 4da94c2facf0
Create Date: 2025-09-19 10:50:33.877390

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "1541fb9cfe23"
down_revision: str | Sequence[str] | None = "4da94c2facf0"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "time_sku_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", sa.Date(), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tskuf_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_tskuf_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", "ts", name="pk_time_sku_features"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "sku_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "sku_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )

    # TimescaleDB hypertable configuration
    bind = op.get_bind()
    bind.execute(sa.text("CREATE EXTENSION IF NOT EXISTS timescaledb;"))

    # time_sku_features
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_sku_features', 'ts',
        partitioning_column => 'sku_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_sku_features', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_sku_features"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,sku_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_sku_features', INTERVAL '30 days');"))
    op.drop_table("staging_time_sku_features_2022_11_ed0c3595")
    op.drop_table("staging_time_sku_features_2024_05_9c3dd9a9")
    op.drop_table("staging_time_sku_features_2024_06_5bceb3f2")
    op.drop_table("staging_time_sku_features_2023_06_16637fd2")
    op.drop_table("staging_time_sku_features_2023_12_4932a51a")
    op.drop_table("staging_time_sku_features_2022_09_3d8f76d9")
    op.drop_table("staging_time_sku_features_2020_10_5b622c69")
    op.drop_table("staging_time_sku_features_2022_01_01f51a7f")
    op.drop_table("staging_time_sku_features_2023_09_bb8f0b28")
    op.drop_table("staging_time_sku_features_2022_09_6ca5c7bb")
    op.drop_table("staging_time_sku_features_2024_02_8232a33c")
    op.drop_table("staging_time_sku_features_2021_09_ab352ab1")
    op.drop_table("staging_time_sku_features_2022_05_861ee409")
    op.drop_table("staging_time_sku_features_2022_04_815dfd4f")
    op.drop_table("staging_time_sku_features_2024_04_fcdb244a")
    op.drop_table("staging_time_sku_features_2021_07_8f87ef37")
    op.drop_table("staging_time_sku_features_2023_10_e2174d65")
    op.drop_table("staging_time_sku_features_2021_05_eea75e68")
    op.drop_table("staging_time_sku_features_2021_03_5c8cb692")
    op.drop_table("staging_time_sku_features_2020_11_b39d4289")
    op.drop_table("staging_time_sku_features_2024_06_96479225")
    op.drop_table("staging_time_sku_features_2022_03_efde782a")
    op.drop_table("staging_time_sku_features_2022_12_28317c69")
    op.drop_table("staging_time_sku_features_2021_05_0bf6c6b7")
    op.drop_table("staging_time_sku_features_2021_02_851afd29")
    op.drop_table("staging_time_sku_features_2024_02_e45b9c9d")
    op.drop_table("staging_time_sku_features_2022_07_01ec77d6")
    op.drop_table("staging_time_sku_features_2024_01_ab7b587e")
    op.drop_table("staging_time_sku_features_2023_02_4036d5b8")
    op.drop_table("staging_time_sku_features_2023_11_a44c4ad7")
    op.drop_table("staging_time_sku_features_2022_10_bd4cebd4")
    op.drop_table("staging_time_sku_features_2022_06_1b9e752d")
    op.drop_table("staging_time_sku_features_2023_07_e3dcdf31")
    op.drop_table("staging_time_sku_features_2021_12_bd9cd3a4")
    op.drop_table("staging_time_sku_features_2023_08_24608239")
    op.drop_table("staging_time_sku_features_2020_09_0792895b")
    op.drop_table("staging_time_sku_features_2023_08_e1458197")
    op.drop_table("staging_time_sku_features_2024_04_daa14578")
    op.drop_table("staging_time_sku_features_2022_10_b1d7cd2c")
    op.drop_table("staging_time_sku_features_2023_04_cd6e5436")
    op.drop_table("staging_time_sku_features_2021_07_a6546d50")
    op.drop_table("staging_time_sku_features_2023_09_a5c43e53")
    op.drop_table("staging_time_sku_features_2022_06_d919dbeb")
    op.drop_table("staging_time_sku_features_2021_04_2afe1b97")
    op.drop_table("staging_time_sku_features_2021_06_55c9b367")
    op.drop_table("staging_time_sku_features_2022_07_05d4390c")
    op.drop_table("staging_time_sku_features_2023_06_2c47c349")
    op.drop_table("staging_time_sku_features_2021_09_0362baf2")
    op.drop_table("staging_time_sku_features_2022_04_f3f56e7c")
    op.drop_table("staging_time_sku_features_2022_08_1bcc5f37")
    op.drop_table("staging_time_sku_features_2021_01_519cc579")
    op.drop_table("staging_time_sku_features_2024_03_c59ddfc9")
    op.drop_table("staging_time_sku_features_2020_09_66f5cf96")
    op.drop_table("staging_time_sku_features_2021_11_8c5a6e11")
    op.drop_table("staging_time_sku_features_2022_02_21b1bdd1")
    op.drop_table("staging_time_sku_features_2020_08_4e539bb1")
    op.drop_table("staging_time_sku_features_2022_11_51f5f4a5")
    op.drop_table("staging_time_sku_features_2023_04_9d2d48f8")
    op.drop_table("staging_time_sku_features_2022_12_199eca6a")
    op.drop_table("staging_time_sku_features_2021_08_0c16f728")
    op.drop_table("staging_time_sku_features_2023_11_59cc1da3")
    op.drop_table("staging_time_sku_features_2023_01_83e6a2a1")
    op.drop_table("staging_time_sku_features_2023_12_a226c859")
    op.drop_table("staging_time_sku_features_2024_01_e1cbdb38")
    op.drop_table("staging_time_sku_features_2021_12_7b0584ac")
    op.drop_table("staging_time_sku_features_2023_02_13f26f42")
    op.drop_table("staging_time_sku_features_2023_05_bcee0f54")
    op.drop_table("staging_time_sku_features_2021_10_37c1dc58")
    op.drop_table("staging_time_sku_features_2020_12_6ed90162")
    op.drop_table("staging_time_sku_features_2020_11_bc054233")
    op.drop_table("staging_time_sku_features_2022_08_1d7a4ad3")
    op.drop_table("staging_time_sku_features_2023_03_5c19b0e7")
    op.drop_table("staging_time_sku_features_2021_04_ed14dfe5")
    op.drop_table("staging_time_sku_features_2020_08_d44dd27f")
    op.drop_table("staging_time_sku_features_2024_05_5c7cb794")
    op.drop_table("staging_time_sku_features_2020_10_435804d8")
    op.drop_table("staging_time_sku_features_2023_10_471ab1ab")
    op.drop_table("staging_time_sku_features_2021_01_7cc10788")
    op.drop_table("staging_time_sku_features_2021_03_662cb9a4")
    op.drop_table("staging_time_sku_features_2021_10_40b1e60e")
    op.drop_table("staging_time_sku_features_2020_12_9d3db8d9")
    op.drop_table("staging_time_sku_features_2023_01_62fcaeb8")
    op.drop_table("staging_time_sku_features_2021_02_bafdc2bd")
    op.drop_table("staging_time_sku_features_2023_07_ad4db2c2")
    op.drop_table("staging_time_sku_features_2021_06_68a2a43a")
    op.drop_table("staging_time_sku_features_2021_11_b53f63f3")
    op.drop_table("staging_time_sku_features_2023_05_e6d50aae")
    op.drop_table("staging_time_sku_features_2022_05_bd894f29")
    op.drop_table("staging_time_sku_features_2022_01_42a25bd9")
    op.drop_table("staging_time_sku_features_2023_03_645afe94")
    op.drop_table("staging_time_sku_features_2022_02_f95ed454")
    op.drop_table("staging_time_sku_features_2024_03_80e7dd77")
    op.drop_table("staging_time_sku_features_2022_03_bb48b272")
    op.drop_table("staging_time_sku_features_2021_08_800915dc")
    op.drop_index(op.f("ix_clc_asof"), table_name="change_log_committed")
    op.drop_index(op.f("ix_clc_company_delivery"), table_name="change_log_committed")
    op.drop_index(op.f("ix_dbd_company_day"), table_name="deliveries_by_day")
    op.drop_index(op.f("ix_dbd_company_sku_day"), table_name="deliveries_by_day")
    op.drop_index(op.f("ix_oid_company_orderday"), table_name="order_intake_daily")
    op.drop_index(op.f("ix_oid_company_sku_orderday"), table_name="order_intake_daily")
    op.drop_index(op.f("ix_tpf_company_feature_ts"), table_name="time_product_features")
    op.drop_index(op.f("ix_tpf_company_product_ts"), table_name="time_product_features")
    op.drop_index(op.f("ix_tpf_text_company_feature_ts"), table_name="time_product_features_text")
    op.drop_index(op.f("ix_tpf_text_company_product_ts"), table_name="time_product_features_text")
    op.drop_index(op.f("ix_trf_company_feature_ts"), table_name="time_region_features")
    op.drop_index(op.f("ix_trf_company_region_ts"), table_name="time_region_features")
    op.drop_index(op.f("ix_trf_text_company_feature_ts"), table_name="time_region_features_text")
    op.drop_index(op.f("ix_trf_text_company_region_ts"), table_name="time_region_features_text")
    op.drop_index(op.f("ix_tskuf_text_company_feature_ts"), table_name="time_sku_features_text")
    op.drop_index(op.f("ix_tskuf_text_company_sku_ts"), table_name="time_sku_features_text")
    op.drop_index(op.f("ix_tsf_company_feature_ts"), table_name="time_store_features")
    op.drop_index(op.f("ix_tsf_company_store_ts"), table_name="time_store_features")
    op.drop_index(op.f("ix_tsf_text_company_feature_ts"), table_name="time_store_features_text")
    op.drop_index(op.f("ix_tsf_text_company_store_ts"), table_name="time_store_features_text")
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        op.f("ix_tsf_text_company_store_ts"), "time_store_features_text", ["company_id", "store_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tsf_text_company_feature_ts"),
        "time_store_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tsf_company_store_ts"), "time_store_features", ["company_id", "store_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tsf_company_feature_ts"), "time_store_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tskuf_text_company_sku_ts"), "time_sku_features_text", ["company_id", "sku_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tskuf_text_company_feature_ts"),
        "time_sku_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_trf_text_company_region_ts"),
        "time_region_features_text",
        ["company_id", "region_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_trf_text_company_feature_ts"),
        "time_region_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_trf_company_region_ts"), "time_region_features", ["company_id", "region_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_trf_company_feature_ts"), "time_region_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tpf_text_company_product_ts"),
        "time_product_features_text",
        ["company_id", "product_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tpf_text_company_feature_ts"),
        "time_product_features_text",
        ["company_id", "feature_id", "ts"],
        unique=False,
    )
    op.create_index(
        op.f("ix_tpf_company_product_ts"), "time_product_features", ["company_id", "product_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_tpf_company_feature_ts"), "time_product_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        op.f("ix_oid_company_sku_orderday"), "order_intake_daily", ["company_id", "sku_id", "order_day"], unique=False
    )
    op.create_index(op.f("ix_oid_company_orderday"), "order_intake_daily", ["company_id", "order_day"], unique=False)
    op.create_index(
        op.f("ix_dbd_company_sku_day"), "deliveries_by_day", ["company_id", "sku_id", "delivery_day"], unique=False
    )
    op.create_index(op.f("ix_dbd_company_day"), "deliveries_by_day", ["company_id", "delivery_day"], unique=False)
    op.create_index(
        op.f("ix_clc_company_delivery"),
        "change_log_committed",
        ["company_id", "delivery_day", "valid_from"],
        unique=False,
    )
    op.create_index(
        op.f("ix_clc_asof"),
        "change_log_committed",
        ["company_id", "sku_id", "delivery_day", "valid_from"],
        unique=False,
    )
    op.create_table(
        "staging_time_sku_features_2021_08_800915dc",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_03_bb48b272",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_03_80e7dd77",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_02_f95ed454",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_03_645afe94",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_01_42a25bd9",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_05_bd894f29",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_05_e6d50aae",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_11_b53f63f3",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_06_68a2a43a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_07_ad4db2c2",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_02_bafdc2bd",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_01_62fcaeb8",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_12_9d3db8d9",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_10_40b1e60e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_03_662cb9a4",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_01_7cc10788",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_10_471ab1ab",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_10_435804d8",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_05_5c7cb794",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_08_d44dd27f",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_04_ed14dfe5",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_03_5c19b0e7",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_08_1d7a4ad3",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_11_bc054233",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_12_6ed90162",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_10_37c1dc58",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_05_bcee0f54",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_02_13f26f42",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_12_7b0584ac",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_01_e1cbdb38",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_12_a226c859",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_01_83e6a2a1",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_11_59cc1da3",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_08_0c16f728",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_12_199eca6a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_04_9d2d48f8",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_11_51f5f4a5",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_08_4e539bb1",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_02_21b1bdd1",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_11_8c5a6e11",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_09_66f5cf96",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_03_c59ddfc9",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_01_519cc579",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_08_1bcc5f37",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_04_f3f56e7c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_09_0362baf2",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_06_2c47c349",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_07_05d4390c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_06_55c9b367",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_04_2afe1b97",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_06_d919dbeb",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_09_a5c43e53",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_07_a6546d50",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_04_cd6e5436",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_10_b1d7cd2c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_04_daa14578",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_08_e1458197",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_09_0792895b",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_08_24608239",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_12_bd9cd3a4",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_07_e3dcdf31",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_06_1b9e752d",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_10_bd4cebd4",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_11_a44c4ad7",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_02_4036d5b8",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_01_ab7b587e",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_07_01ec77d6",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_02_e45b9c9d",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_02_851afd29",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_05_0bf6c6b7",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_12_28317c69",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_03_efde782a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_06_96479225",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_11_b39d4289",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_03_5c8cb692",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_05_eea75e68",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_10_e2174d65",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_07_8f87ef37",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_04_fcdb244a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_04_815dfd4f",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_05_861ee409",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2021_09_ab352ab1",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_02_8232a33c",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_09_6ca5c7bb",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_09_bb8f0b28",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_01_01f51a7f",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2020_10_5b622c69",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_09_3d8f76d9",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_12_4932a51a",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2023_06_16637fd2",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_06_5bceb3f2",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2024_05_9c3dd9a9",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.create_table(
        "staging_time_sku_features_2022_11_ed0c3595",
        sa.Column("company_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("sku_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("feature_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ts", sa.DATE(), autoincrement=False, nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
    )
    op.drop_table("time_sku_features")
    # ### end Alembic commands ###
