"""
add flags table

Revision ID: 4da94c2facf0
Revises: d2470bbb912d
Create Date: 2025-09-19 01:37:50.281264

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "4da94c2facf0"
down_revision: str | Sequence[str] | None = "d2470bbb912d"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    bind = op.get_bind()
    bind.execute(sa.text("CREATE EXTENSION IF NOT EXISTS timescaledb;"))

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "flags",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", sa.Date(), nullable=False),
        sa.Column("value", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_flags_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_flags_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", "ts", name="pk_flags"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "sku_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "sku_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )

    # TimescaleDB setup for new flags table
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'flags', 'ts',
        partitioning_column => 'sku_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('flags', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "flags"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,sku_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('flags', INTERVAL '30 days');"))
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("flags")
    # ### end Alembic commands ###
