"""

Revision ID: 17e51420e7ad
Revises: d663166c531d
Create Date: 2025-07-10 17:35:02.376675

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "17e51420e7ad"
down_revision: Union[str, None] = "d663166c531d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("rsi_bullish_crossover_30", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("rsi_bullish_crossover_40", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("rsi_bullish_crossover_45", sa.Date(), nullable=True)
        )
        batch_op.add_column(
            sa.Column(
                "return_after_rsi_crossover_45_period_90", sa.Float(), nullable=True
            )
        )
        batch_op.drop_index(batch_op.f("ix_analysis_rsi_bullish_crossover"))
        batch_op.create_index(
            "ix_analysis_return_after_rsi_crossover_45_period_90",
            ["return_after_rsi_crossover_45_period_90"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_rsi_bullish_crossover_30",
            ["rsi_bullish_crossover_30"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_rsi_bullish_crossover_40",
            ["rsi_bullish_crossover_40"],
            unique=False,
        )
        batch_op.create_index(
            "ix_analysis_rsi_bullish_crossover_45",
            ["rsi_bullish_crossover_45"],
            unique=False,
        )
        batch_op.drop_column("rsi_bullish_crossover")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("rsi_bullish_crossover", sa.DATE(), nullable=True)
        )
        batch_op.drop_index("ix_analysis_rsi_bullish_crossover_45")
        batch_op.drop_index("ix_analysis_rsi_bullish_crossover_40")
        batch_op.drop_index("ix_analysis_rsi_bullish_crossover_30")
        batch_op.drop_index("ix_analysis_return_after_rsi_crossover_45_period_90")
        batch_op.create_index(
            batch_op.f("ix_analysis_rsi_bullish_crossover"),
            ["rsi_bullish_crossover"],
            unique=False,
        )
        batch_op.drop_column("return_after_rsi_crossover_45_period_90")
        batch_op.drop_column("rsi_bullish_crossover_45")
        batch_op.drop_column("rsi_bullish_crossover_40")
        batch_op.drop_column("rsi_bullish_crossover_30")

    # ### end Alembic commands ###
