"""

Revision ID: ec25c8fa449f
Revises: 5b10ee7604c1
Create Date: 2025-07-14 12:26:29.346903

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "ec25c8fa449f"
down_revision: Union[str, None] = "5b10ee7604c1"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "industryreturns",
        sa.Column("date", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("created_at", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("simple_return", sa.Float(), nullable=True),
        sa.Column("log_return", sa.Float(), nullable=True),
        sa.Column("country", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("industry", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("industry_group", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("sector", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("type", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("date", "country", "industry", "type"),
    )

    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_analysis_return_after_rsi_crossover_45_period_90")
        )
        batch_op.drop_column("return_after_rsi_crossover_45_period_90")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "return_after_rsi_crossover_45_period_90", sa.FLOAT(), nullable=True
            )
        )
        batch_op.create_index(
            batch_op.f("ix_analysis_return_after_rsi_crossover_45_period_90"),
            ["return_after_rsi_crossover_45_period_90"],
            unique=False,
        )

    op.drop_table("industryreturns")
    # ### end Alembic commands ###
