"""

Revision ID: ff0cc4ba40ec
Revises: 79bc71ec6f9e
Create Date: 2025-08-05 12:09:12.108606

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "ff0cc4ba40ec"
down_revision: Union[str, None] = "79bc71ec6f9e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("average_volume_10", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("average_volume_30", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("volume_above_average", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("weekly_growth", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("monthly_growth", sa.Float(), nullable=True))
        batch_op.add_column(sa.Column("yearly_growth", sa.Float(), nullable=True))
        batch_op.create_index(
            "ix_analysis_average_volume_10", ["average_volume_10"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_average_volume_30", ["average_volume_30"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_monthly_growth", ["monthly_growth"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_volume_above_average", ["volume_above_average"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_weekly_growth", ["weekly_growth"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_yearly_growth", ["yearly_growth"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_yearly_growth")
        batch_op.drop_index("ix_analysis_weekly_growth")
        batch_op.drop_index("ix_analysis_volume_above_average")
        batch_op.drop_index("ix_analysis_monthly_growth")
        batch_op.drop_index("ix_analysis_average_volume_30")
        batch_op.drop_index("ix_analysis_average_volume_10")
        batch_op.drop_column("yearly_growth")
        batch_op.drop_column("monthly_growth")
        batch_op.drop_column("weekly_growth")
        batch_op.drop_column("volume_above_average")
        batch_op.drop_column("average_volume_30")
        batch_op.drop_column("average_volume_10")

    # ### end Alembic commands ###
