# Copyright 2023 Cognite AS
from .array_operations import time_weighted_mean, time_weighted_std, timeseries_max, timeseries_min
from .logarithmic_functions import exp, log, log2, log10, logn
from .logical_operations import logical_check
from .numerical_calculus import differentiate, sliding_window_integration, trapezoidal_integration
from .operators import absolute, add, arithmetic_mean, div, inv, mod, mul, neg, power, sample_average, sqrt, sub
from .rolling_stats import rolling_stddev, rolling_variance
from .trigonometric_functions import (
    arccos,
    arccosh,
    arcsin,
    arcsinh,
    arctan,
    arctan2,
    arctanh,
    cos,
    cosh,
    deg2rad,
    rad2deg,
    sin,
    sinh,
    tan,
    tanh,
)
from .ts_utils import (
    above_below,
    check_uniform,
    datetime_to_ms,
    fill_gaps,
    functional_mean,
    gaps_detector,
    get_fixed_freq,
    granularity_to_ms,
    is_na_all,
    mad,
    make_uniform,
    num_vals_in_boxes,
    number_of_events,
    scalar_to_pandas_series,
    time_ago_to_ms,
    time_difference,
    time_parse,
    time_string_to_ms,
    time_to_points,
)
from .utility_functions import (
    bin_map,
    ceil,
    clip,
    floor,
    get_timestamps,
    maximum,
    minimum,
    remove,
    replace,
    round,
    set_timestamps,
    sign,
    threshold,
    time_shift,
    union,
)


TOOLBOX_NAME = "Operators"

__all__ = [
    "above_below",
    "absolute",
    "add",
    "arccos",
    "arccosh",
    "arcsin",
    "arcsinh",
    "arctan",
    "arctan2",
    "arctanh",
    "arithmetic_mean",
    "bin_map",
    "ceil",
    "check_uniform",
    "clip",
    "cos",
    "cosh",
    "datetime_to_ms",
    "deg2rad",
    "differentiate",
    "div",
    "exp",
    "fill_gaps",
    "floor",
    "functional_mean",
    "gaps_detector",
    "get_fixed_freq",
    "get_timestamps",
    "granularity_to_ms",
    "inv",
    "is_na_all",
    "log",
    "log2",
    "log10",
    "logical_check",
    "logn",
    "mad",
    "make_uniform",
    "maximum",
    "minimum",
    "mod",
    "mul",
    "neg",
    "num_vals_in_boxes",
    "number_of_events",
    "power",
    "rad2deg",
    "remove",
    "replace",
    "rolling_stddev",
    "rolling_variance",
    "round",
    "sample_average",
    "scalar_to_pandas_series",
    "set_timestamps",
    "sign",
    "sin",
    "sinh",
    "sliding_window_integration",
    "sqrt",
    "sub",
    "tan",
    "tanh",
    "threshold",
    "time_ago_to_ms",
    "time_difference",
    "time_parse",
    "time_shift",
    "time_string_to_ms",
    "time_to_points",
    "time_weighted_mean",
    "time_weighted_std",
    "timeseries_max",
    "timeseries_min",
    "trapezoidal_integration",
    "union",
]


__cognite__ = [
    "add",
    "sub",
    "mul",
    "div",
    "absolute",
    "inv",
    "mod",
    "neg",
    "power",
    "sqrt",
    "sin",
    "cos",
    "tan",
    "arccos",
    "arcsin",
    "arctan",
    "arctan2",
    "deg2rad",
    "rad2deg",
    "sinh",
    "cosh",
    "tanh",
    "arcsinh",
    "arccosh",
    "arctanh",
    "exp",
    "log",
    "log2",
    "log10",
    "logn",
    "clip",
    "replace",
    "remove",
    "maximum",
    "minimum",
    "sample_average",
    "union",
    "bin_map",
    "get_timestamps",
    "set_timestamps",
    "time_shift",
    "ceil",
    "floor",
    "round",
    "sign",
    "trapezoidal_integration",
    "differentiate",
    "threshold",
    "sliding_window_integration",
    "arithmetic_mean",
    "logical_check",
    "time_weighted_mean",
    "time_weighted_std",
    "timeseries_max",
    "timeseries_min",
    "rolling_stddev",
    "rolling_variance",
]
