#  Pyrogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of Pyrogram.
#
#  Pyrogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Pyrogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from .advanced import Advanced
from .auth import Auth
from .bots import Bots
from .chats import Chats
from .chat_topics import ChatTopics
from .contacts import Contacts
from .decorators import Decorators
from .invite_links import InviteLinks
from .messages import Messages
from .password import Password
from .phone import Phone
from .stickers import Stickers
from .stories import Stories
from .users import Users
from .utilities import Utilities
from .business import TelegramBusiness


class Methods(
    Decorators,
    Advanced,
    Auth,
    Bots,
    Chats,
    ChatTopics,
    Contacts,
    InviteLinks,
    Messages,
    Password,
    Phone,
    Stickers,
    Stories,
    TelegramBusiness,
    Users,
    Utilities,
):
    pass
