# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.address import Address
from ..types.client_facing_payor import ClientFacingPayor
from ..types.payor_code_external_provider import PayorCodeExternalProvider
from .raw_client import AsyncRawPayorClient, RawPayorClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PayorClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPayorClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPayorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPayorClient
        """
        return self._raw_client

    def create_payor(
        self,
        *,
        name: str,
        address: Address,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_payor_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingPayor:
        """
        Parameters
        ----------
        name : str

        address : Address

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingPayor
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import Address
        client = Vital(api_key="YOUR_API_KEY", )
        client.payor.create_payor(name='name', address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), )
        """
        _response = self._raw_client.create_payor(
            name=name,
            address=address,
            provider=provider,
            provider_payor_id=provider_payor_id,
            request_options=request_options,
        )
        return _response.data


class AsyncPayorClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPayorClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPayorClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPayorClient
        """
        return self._raw_client

    async def create_payor(
        self,
        *,
        name: str,
        address: Address,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_payor_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingPayor:
        """
        Parameters
        ----------
        name : str

        address : Address

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingPayor
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import Address
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.payor.create_payor(name='name', address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_payor(
            name=name,
            address=address,
            provider=provider,
            provider_payor_id=provider_payor_id,
            request_options=request_options,
        )
        return _response.data
