# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityGovernanceRuleResult',
    'AwaitableGetSecurityGovernanceRuleResult',
    'get_security_governance_rule',
    'get_security_governance_rule_output',
]

@pulumi.output_type
class GetSecurityGovernanceRuleResult:
    """
    A collection of values returned by getSecurityGovernanceRule.
    """
    def __init__(__self__, condition_ids=None, description=None, id=None, is_enabled=None, name=None, org_id=None, project_id=None, tags=None, time_windows=None, user_group_ids=None):
        if condition_ids and not isinstance(condition_ids, list):
            raise TypeError("Expected argument 'condition_ids' to be a list")
        pulumi.set(__self__, "condition_ids", condition_ids)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if time_windows and not isinstance(time_windows, list):
            raise TypeError("Expected argument 'time_windows' to be a list")
        pulumi.set(__self__, "time_windows", time_windows)
        if user_group_ids and not isinstance(user_group_ids, list):
            raise TypeError("Expected argument 'user_group_ids' to be a list")
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="conditionIds")
    def condition_ids(self) -> Sequence[_builtins.str]:
        """
        List of condition IDs associated with the rule.
        """
        return pulumi.get(self, "condition_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Whether the rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        """
        The organization identifier.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The project identifier.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags associated with the rule.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Sequence['outputs.GetSecurityGovernanceRuleTimeWindowResult']:
        """
        Time windows when the rule is active.
        """
        return pulumi.get(self, "time_windows")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[_builtins.str]:
        """
        List of user group IDs associated with the rule.
        """
        return pulumi.get(self, "user_group_ids")


class AwaitableGetSecurityGovernanceRuleResult(GetSecurityGovernanceRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGovernanceRuleResult(
            condition_ids=self.condition_ids,
            description=self.description,
            id=self.id,
            is_enabled=self.is_enabled,
            name=self.name,
            org_id=self.org_id,
            project_id=self.project_id,
            tags=self.tags,
            time_windows=self.time_windows,
            user_group_ids=self.user_group_ids)


def get_security_governance_rule(id: Optional[_builtins.str] = None,
                                 name: Optional[_builtins.str] = None,
                                 org_id: Optional[_builtins.str] = None,
                                 project_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGovernanceRuleResult:
    """
    Data source for retrieving a Harness Chaos Security Governance Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data sources to verify the rules
    example = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    example_linux = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    example_windows = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    ```


    :param _builtins.str id: The ID of the rule.
    :param _builtins.str name: The name of the rule.
    :param _builtins.str org_id: The organization identifier.
    :param _builtins.str project_id: The project identifier.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:chaos/getSecurityGovernanceRule:getSecurityGovernanceRule', __args__, opts=opts, typ=GetSecurityGovernanceRuleResult).value

    return AwaitableGetSecurityGovernanceRuleResult(
        condition_ids=pulumi.get(__ret__, 'condition_ids'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        name=pulumi.get(__ret__, 'name'),
        org_id=pulumi.get(__ret__, 'org_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        time_windows=pulumi.get(__ret__, 'time_windows'),
        user_group_ids=pulumi.get(__ret__, 'user_group_ids'))
def get_security_governance_rule_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                        org_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityGovernanceRuleResult]:
    """
    Data source for retrieving a Harness Chaos Security Governance Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data sources to verify the rules
    example = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    example_linux = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    example_windows = harness.chaos.get_security_governance_rule(id="<rule_id>",
        org_id="<org_id>",
        project_id="<project_id>")
    ```


    :param _builtins.str id: The ID of the rule.
    :param _builtins.str name: The name of the rule.
    :param _builtins.str org_id: The organization identifier.
    :param _builtins.str project_id: The project identifier.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['orgId'] = org_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:chaos/getSecurityGovernanceRule:getSecurityGovernanceRule', __args__, opts=opts, typ=GetSecurityGovernanceRuleResult)
    return __ret__.apply(lambda __response__: GetSecurityGovernanceRuleResult(
        condition_ids=pulumi.get(__response__, 'condition_ids'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        name=pulumi.get(__response__, 'name'),
        org_id=pulumi.get(__response__, 'org_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        tags=pulumi.get(__response__, 'tags'),
        time_windows=pulumi.get(__response__, 'time_windows'),
        user_group_ids=pulumi.get(__response__, 'user_group_ids')))
