# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsConnectorArgs', 'AwsConnector']

@pulumi.input_type
class AwsConnectorArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[_builtins.str],
                 cross_account_access: Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 equal_jitter_backoff_strategy: Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_delay_backoff_strategy: Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_jitter_backoff_strategy: Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']] = None,
                 inherit_from_delegate: Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']] = None,
                 irsa: Optional[pulumi.Input['AwsConnectorIrsaArgs']] = None,
                 manual: Optional[pulumi.Input['AwsConnectorManualArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentication: Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AwsConnector resource.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input['AwsConnectorCrossAccountAccessArgs'] cross_account_access: Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs'] equal_jitter_backoff_strategy: Equal Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate
        :param pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs'] fixed_delay_backoff_strategy: Fixed Delay BackOff Strategy.
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs'] full_jitter_backoff_strategy: Full Jitter BackOff Strategy.
        :param pulumi.Input['AwsConnectorInheritFromDelegateArgs'] inherit_from_delegate: Inherit credentials from the delegate.
        :param pulumi.Input['AwsConnectorIrsaArgs'] irsa: Use IAM role for service accounts.
        :param pulumi.Input['AwsConnectorManualArgs'] manual: Use IAM role for service accounts.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input['AwsConnectorOidcAuthenticationArgs'] oidc_authentication: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "identifier", identifier)
        if cross_account_access is not None:
            pulumi.set(__self__, "cross_account_access", cross_account_access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if equal_jitter_backoff_strategy is not None:
            pulumi.set(__self__, "equal_jitter_backoff_strategy", equal_jitter_backoff_strategy)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if fixed_delay_backoff_strategy is not None:
            pulumi.set(__self__, "fixed_delay_backoff_strategy", fixed_delay_backoff_strategy)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if full_jitter_backoff_strategy is not None:
            pulumi.set(__self__, "full_jitter_backoff_strategy", full_jitter_backoff_strategy)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if irsa is not None:
            pulumi.set(__self__, "irsa", irsa)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentication is not None:
            pulumi.set(__self__, "oidc_authentication", oidc_authentication)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="crossAccountAccess")
    def cross_account_access(self) -> Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']]:
        """
        Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        """
        return pulumi.get(self, "cross_account_access")

    @cross_account_access.setter
    def cross_account_access(self, value: Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']]):
        pulumi.set(self, "cross_account_access", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="equalJitterBackoffStrategy")
    def equal_jitter_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']]:
        """
        Equal Jitter BackOff Strategy.
        """
        return pulumi.get(self, "equal_jitter_backoff_strategy")

    @equal_jitter_backoff_strategy.setter
    def equal_jitter_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']]):
        pulumi.set(self, "equal_jitter_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="fixedDelayBackoffStrategy")
    def fixed_delay_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']]:
        """
        Fixed Delay BackOff Strategy.
        """
        return pulumi.get(self, "fixed_delay_backoff_strategy")

    @fixed_delay_backoff_strategy.setter
    def fixed_delay_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']]):
        pulumi.set(self, "fixed_delay_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="fullJitterBackoffStrategy")
    def full_jitter_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']]:
        """
        Full Jitter BackOff Strategy.
        """
        return pulumi.get(self, "full_jitter_backoff_strategy")

    @full_jitter_backoff_strategy.setter
    def full_jitter_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']]):
        pulumi.set(self, "full_jitter_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']]:
        """
        Inherit credentials from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']]):
        pulumi.set(self, "inherit_from_delegate", value)

    @_builtins.property
    @pulumi.getter
    def irsa(self) -> Optional[pulumi.Input['AwsConnectorIrsaArgs']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "irsa")

    @irsa.setter
    def irsa(self, value: Optional[pulumi.Input['AwsConnectorIrsaArgs']]):
        pulumi.set(self, "irsa", value)

    @_builtins.property
    @pulumi.getter
    def manual(self) -> Optional[pulumi.Input['AwsConnectorManualArgs']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "manual")

    @manual.setter
    def manual(self, value: Optional[pulumi.Input['AwsConnectorManualArgs']]):
        pulumi.set(self, "manual", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentication")
    def oidc_authentication(self) -> Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentication")

    @oidc_authentication.setter
    def oidc_authentication(self, value: Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']]):
        pulumi.set(self, "oidc_authentication", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AwsConnectorState:
    def __init__(__self__, *,
                 cross_account_access: Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 equal_jitter_backoff_strategy: Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_delay_backoff_strategy: Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_jitter_backoff_strategy: Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']] = None,
                 irsa: Optional[pulumi.Input['AwsConnectorIrsaArgs']] = None,
                 manual: Optional[pulumi.Input['AwsConnectorManualArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentication: Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AwsConnector resources.
        :param pulumi.Input['AwsConnectorCrossAccountAccessArgs'] cross_account_access: Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs'] equal_jitter_backoff_strategy: Equal Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate
        :param pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs'] fixed_delay_backoff_strategy: Fixed Delay BackOff Strategy.
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs'] full_jitter_backoff_strategy: Full Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input['AwsConnectorInheritFromDelegateArgs'] inherit_from_delegate: Inherit credentials from the delegate.
        :param pulumi.Input['AwsConnectorIrsaArgs'] irsa: Use IAM role for service accounts.
        :param pulumi.Input['AwsConnectorManualArgs'] manual: Use IAM role for service accounts.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input['AwsConnectorOidcAuthenticationArgs'] oidc_authentication: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if cross_account_access is not None:
            pulumi.set(__self__, "cross_account_access", cross_account_access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if equal_jitter_backoff_strategy is not None:
            pulumi.set(__self__, "equal_jitter_backoff_strategy", equal_jitter_backoff_strategy)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if fixed_delay_backoff_strategy is not None:
            pulumi.set(__self__, "fixed_delay_backoff_strategy", fixed_delay_backoff_strategy)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if full_jitter_backoff_strategy is not None:
            pulumi.set(__self__, "full_jitter_backoff_strategy", full_jitter_backoff_strategy)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if inherit_from_delegate is not None:
            pulumi.set(__self__, "inherit_from_delegate", inherit_from_delegate)
        if irsa is not None:
            pulumi.set(__self__, "irsa", irsa)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentication is not None:
            pulumi.set(__self__, "oidc_authentication", oidc_authentication)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="crossAccountAccess")
    def cross_account_access(self) -> Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']]:
        """
        Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        """
        return pulumi.get(self, "cross_account_access")

    @cross_account_access.setter
    def cross_account_access(self, value: Optional[pulumi.Input['AwsConnectorCrossAccountAccessArgs']]):
        pulumi.set(self, "cross_account_access", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="equalJitterBackoffStrategy")
    def equal_jitter_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']]:
        """
        Equal Jitter BackOff Strategy.
        """
        return pulumi.get(self, "equal_jitter_backoff_strategy")

    @equal_jitter_backoff_strategy.setter
    def equal_jitter_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorEqualJitterBackoffStrategyArgs']]):
        pulumi.set(self, "equal_jitter_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="fixedDelayBackoffStrategy")
    def fixed_delay_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']]:
        """
        Fixed Delay BackOff Strategy.
        """
        return pulumi.get(self, "fixed_delay_backoff_strategy")

    @fixed_delay_backoff_strategy.setter
    def fixed_delay_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorFixedDelayBackoffStrategyArgs']]):
        pulumi.set(self, "fixed_delay_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="fullJitterBackoffStrategy")
    def full_jitter_backoff_strategy(self) -> Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']]:
        """
        Full Jitter BackOff Strategy.
        """
        return pulumi.get(self, "full_jitter_backoff_strategy")

    @full_jitter_backoff_strategy.setter
    def full_jitter_backoff_strategy(self, value: Optional[pulumi.Input['AwsConnectorFullJitterBackoffStrategyArgs']]):
        pulumi.set(self, "full_jitter_backoff_strategy", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']]:
        """
        Inherit credentials from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @inherit_from_delegate.setter
    def inherit_from_delegate(self, value: Optional[pulumi.Input['AwsConnectorInheritFromDelegateArgs']]):
        pulumi.set(self, "inherit_from_delegate", value)

    @_builtins.property
    @pulumi.getter
    def irsa(self) -> Optional[pulumi.Input['AwsConnectorIrsaArgs']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "irsa")

    @irsa.setter
    def irsa(self, value: Optional[pulumi.Input['AwsConnectorIrsaArgs']]):
        pulumi.set(self, "irsa", value)

    @_builtins.property
    @pulumi.getter
    def manual(self) -> Optional[pulumi.Input['AwsConnectorManualArgs']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "manual")

    @manual.setter
    def manual(self, value: Optional[pulumi.Input['AwsConnectorManualArgs']]):
        pulumi.set(self, "manual", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentication")
    def oidc_authentication(self) -> Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentication")

    @oidc_authentication.setter
    def oidc_authentication(self, value: Optional[pulumi.Input['AwsConnectorOidcAuthenticationArgs']]):
        pulumi.set(self, "oidc_authentication", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:platform/awsConnector:AwsConnector")
class AwsConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_account_access: Optional[pulumi.Input[Union['AwsConnectorCrossAccountAccessArgs', 'AwsConnectorCrossAccountAccessArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 equal_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorEqualJitterBackoffStrategyArgs', 'AwsConnectorEqualJitterBackoffStrategyArgsDict']]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_delay_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFixedDelayBackoffStrategyArgs', 'AwsConnectorFixedDelayBackoffStrategyArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFullJitterBackoffStrategyArgs', 'AwsConnectorFullJitterBackoffStrategyArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[Union['AwsConnectorInheritFromDelegateArgs', 'AwsConnectorInheritFromDelegateArgsDict']]] = None,
                 irsa: Optional[pulumi.Input[Union['AwsConnectorIrsaArgs', 'AwsConnectorIrsaArgsDict']]] = None,
                 manual: Optional[pulumi.Input[Union['AwsConnectorManualArgs', 'AwsConnectorManualArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentication: Optional[pulumi.Input[Union['AwsConnectorOidcAuthenticationArgs', 'AwsConnectorOidcAuthenticationArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating an AWS connector.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <connector_id>
        ```

        Import organization level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <organization_id>/<connector_id>
        ```

        Import project level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <organization_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsConnectorCrossAccountAccessArgs', 'AwsConnectorCrossAccountAccessArgsDict']] cross_account_access: Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['AwsConnectorEqualJitterBackoffStrategyArgs', 'AwsConnectorEqualJitterBackoffStrategyArgsDict']] equal_jitter_backoff_strategy: Equal Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate
        :param pulumi.Input[Union['AwsConnectorFixedDelayBackoffStrategyArgs', 'AwsConnectorFixedDelayBackoffStrategyArgsDict']] fixed_delay_backoff_strategy: Fixed Delay BackOff Strategy.
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[Union['AwsConnectorFullJitterBackoffStrategyArgs', 'AwsConnectorFullJitterBackoffStrategyArgsDict']] full_jitter_backoff_strategy: Full Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[Union['AwsConnectorInheritFromDelegateArgs', 'AwsConnectorInheritFromDelegateArgsDict']] inherit_from_delegate: Inherit credentials from the delegate.
        :param pulumi.Input[Union['AwsConnectorIrsaArgs', 'AwsConnectorIrsaArgsDict']] irsa: Use IAM role for service accounts.
        :param pulumi.Input[Union['AwsConnectorManualArgs', 'AwsConnectorManualArgsDict']] manual: Use IAM role for service accounts.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Union['AwsConnectorOidcAuthenticationArgs', 'AwsConnectorOidcAuthenticationArgsDict']] oidc_authentication: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating an AWS connector.

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <connector_id>
        ```

        Import organization level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <organization_id>/<connector_id>
        ```

        Import project level aws connector

        ```sh
        $ pulumi import harness:platform/awsConnector:AwsConnector example <organization_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param AwsConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_account_access: Optional[pulumi.Input[Union['AwsConnectorCrossAccountAccessArgs', 'AwsConnectorCrossAccountAccessArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 equal_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorEqualJitterBackoffStrategyArgs', 'AwsConnectorEqualJitterBackoffStrategyArgsDict']]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_delay_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFixedDelayBackoffStrategyArgs', 'AwsConnectorFixedDelayBackoffStrategyArgsDict']]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFullJitterBackoffStrategyArgs', 'AwsConnectorFullJitterBackoffStrategyArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 inherit_from_delegate: Optional[pulumi.Input[Union['AwsConnectorInheritFromDelegateArgs', 'AwsConnectorInheritFromDelegateArgsDict']]] = None,
                 irsa: Optional[pulumi.Input[Union['AwsConnectorIrsaArgs', 'AwsConnectorIrsaArgsDict']]] = None,
                 manual: Optional[pulumi.Input[Union['AwsConnectorManualArgs', 'AwsConnectorManualArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentication: Optional[pulumi.Input[Union['AwsConnectorOidcAuthenticationArgs', 'AwsConnectorOidcAuthenticationArgsDict']]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsConnectorArgs.__new__(AwsConnectorArgs)

            __props__.__dict__["cross_account_access"] = cross_account_access
            __props__.__dict__["description"] = description
            __props__.__dict__["equal_jitter_backoff_strategy"] = equal_jitter_backoff_strategy
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            __props__.__dict__["fixed_delay_backoff_strategy"] = fixed_delay_backoff_strategy
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["full_jitter_backoff_strategy"] = full_jitter_backoff_strategy
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
            __props__.__dict__["irsa"] = irsa
            __props__.__dict__["manual"] = manual
            __props__.__dict__["name"] = name
            __props__.__dict__["oidc_authentication"] = oidc_authentication
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
        super(AwsConnector, __self__).__init__(
            'harness:platform/awsConnector:AwsConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cross_account_access: Optional[pulumi.Input[Union['AwsConnectorCrossAccountAccessArgs', 'AwsConnectorCrossAccountAccessArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            equal_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorEqualJitterBackoffStrategyArgs', 'AwsConnectorEqualJitterBackoffStrategyArgsDict']]] = None,
            execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            fixed_delay_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFixedDelayBackoffStrategyArgs', 'AwsConnectorFixedDelayBackoffStrategyArgsDict']]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            full_jitter_backoff_strategy: Optional[pulumi.Input[Union['AwsConnectorFullJitterBackoffStrategyArgs', 'AwsConnectorFullJitterBackoffStrategyArgsDict']]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            inherit_from_delegate: Optional[pulumi.Input[Union['AwsConnectorInheritFromDelegateArgs', 'AwsConnectorInheritFromDelegateArgsDict']]] = None,
            irsa: Optional[pulumi.Input[Union['AwsConnectorIrsaArgs', 'AwsConnectorIrsaArgsDict']]] = None,
            manual: Optional[pulumi.Input[Union['AwsConnectorManualArgs', 'AwsConnectorManualArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_authentication: Optional[pulumi.Input[Union['AwsConnectorOidcAuthenticationArgs', 'AwsConnectorOidcAuthenticationArgsDict']]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AwsConnector':
        """
        Get an existing AwsConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AwsConnectorCrossAccountAccessArgs', 'AwsConnectorCrossAccountAccessArgsDict']] cross_account_access: Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[Union['AwsConnectorEqualJitterBackoffStrategyArgs', 'AwsConnectorEqualJitterBackoffStrategyArgsDict']] equal_jitter_backoff_strategy: Equal Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate
        :param pulumi.Input[Union['AwsConnectorFixedDelayBackoffStrategyArgs', 'AwsConnectorFixedDelayBackoffStrategyArgsDict']] fixed_delay_backoff_strategy: Fixed Delay BackOff Strategy.
        :param pulumi.Input[_builtins.bool] force_delete: Enable this flag for force deletion of connector
        :param pulumi.Input[Union['AwsConnectorFullJitterBackoffStrategyArgs', 'AwsConnectorFullJitterBackoffStrategyArgsDict']] full_jitter_backoff_strategy: Full Jitter BackOff Strategy.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[Union['AwsConnectorInheritFromDelegateArgs', 'AwsConnectorInheritFromDelegateArgsDict']] inherit_from_delegate: Inherit credentials from the delegate.
        :param pulumi.Input[Union['AwsConnectorIrsaArgs', 'AwsConnectorIrsaArgsDict']] irsa: Use IAM role for service accounts.
        :param pulumi.Input[Union['AwsConnectorManualArgs', 'AwsConnectorManualArgsDict']] manual: Use IAM role for service accounts.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Union['AwsConnectorOidcAuthenticationArgs', 'AwsConnectorOidcAuthenticationArgsDict']] oidc_authentication: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsConnectorState.__new__(_AwsConnectorState)

        __props__.__dict__["cross_account_access"] = cross_account_access
        __props__.__dict__["description"] = description
        __props__.__dict__["equal_jitter_backoff_strategy"] = equal_jitter_backoff_strategy
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["fixed_delay_backoff_strategy"] = fixed_delay_backoff_strategy
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["full_jitter_backoff_strategy"] = full_jitter_backoff_strategy
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["inherit_from_delegate"] = inherit_from_delegate
        __props__.__dict__["irsa"] = irsa
        __props__.__dict__["manual"] = manual
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc_authentication"] = oidc_authentication
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        return AwsConnector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="crossAccountAccess")
    def cross_account_access(self) -> pulumi.Output[Optional['outputs.AwsConnectorCrossAccountAccess']]:
        """
        Select this option if you want to use one AWS account for the connection, but you want to deploy or build in a different AWS account. In this scenario, the AWS account used for AWS access in Credentials will assume the IAM role you specify in Cross-account role ARN setting. This option uses the AWS Security Token Service (STS) feature.
        """
        return pulumi.get(self, "cross_account_access")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="equalJitterBackoffStrategy")
    def equal_jitter_backoff_strategy(self) -> pulumi.Output[Optional['outputs.AwsConnectorEqualJitterBackoffStrategy']]:
        """
        Equal Jitter BackOff Strategy.
        """
        return pulumi.get(self, "equal_jitter_backoff_strategy")

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate
        """
        return pulumi.get(self, "execute_on_delegate")

    @_builtins.property
    @pulumi.getter(name="fixedDelayBackoffStrategy")
    def fixed_delay_backoff_strategy(self) -> pulumi.Output[Optional['outputs.AwsConnectorFixedDelayBackoffStrategy']]:
        """
        Fixed Delay BackOff Strategy.
        """
        return pulumi.get(self, "fixed_delay_backoff_strategy")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable this flag for force deletion of connector
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="fullJitterBackoffStrategy")
    def full_jitter_backoff_strategy(self) -> pulumi.Output[Optional['outputs.AwsConnectorFullJitterBackoffStrategy']]:
        """
        Full Jitter BackOff Strategy.
        """
        return pulumi.get(self, "full_jitter_backoff_strategy")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="inheritFromDelegate")
    def inherit_from_delegate(self) -> pulumi.Output[Optional['outputs.AwsConnectorInheritFromDelegate']]:
        """
        Inherit credentials from the delegate.
        """
        return pulumi.get(self, "inherit_from_delegate")

    @_builtins.property
    @pulumi.getter
    def irsa(self) -> pulumi.Output[Optional['outputs.AwsConnectorIrsa']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "irsa")

    @_builtins.property
    @pulumi.getter
    def manual(self) -> pulumi.Output[Optional['outputs.AwsConnectorManual']]:
        """
        Use IAM role for service accounts.
        """
        return pulumi.get(self, "manual")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oidcAuthentication")
    def oidc_authentication(self) -> pulumi.Output[Optional['outputs.AwsConnectorOidcAuthentication']]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentication")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

