# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorGcpKmsArgs', 'ConnectorGcpKms']

@pulumi.input_type
class ConnectorGcpKmsArgs:
    def __init__(__self__, *,
                 gcp_project_id: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input[_builtins.str],
                 key_name: pulumi.Input[_builtins.str],
                 key_ring: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 manual: Optional[pulumi.Input['ConnectorGcpKmsManualArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConnectorGcpKms resource.
        :param pulumi.Input[_builtins.str] gcp_project_id: The project ID of the GCP KMS.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] key_name: The key name of the GCP KMS.
        :param pulumi.Input[_builtins.str] key_ring: The key ring of the GCP KMS.
        :param pulumi.Input[_builtins.str] region: The region of the GCP KMS.
        :param pulumi.Input[_builtins.bool] default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate.
        :param pulumi.Input['ConnectorGcpKmsManualArgs'] manual: Manual credential configuration.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_ring", key_ring)
        pulumi.set(__self__, "region", region)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentications is not None:
            pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The project ID of the GCP KMS.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gcp_project_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The key name of the GCP KMS.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> pulumi.Input[_builtins.str]:
        """
        The key ring of the GCP KMS.
        """
        return pulumi.get(self, "key_ring")

    @key_ring.setter
    def key_ring(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_ring", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the GCP KMS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter
    def manual(self) -> Optional[pulumi.Input['ConnectorGcpKmsManualArgs']]:
        """
        Manual credential configuration.
        """
        return pulumi.get(self, "manual")

    @manual.setter
    def manual(self, value: Optional[pulumi.Input['ConnectorGcpKmsManualArgs']]):
        pulumi.set(self, "manual", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @oidc_authentications.setter
    def oidc_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]]):
        pulumi.set(self, "oidc_authentications", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConnectorGcpKmsState:
    def __init__(__self__, *,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ring: Optional[pulumi.Input[_builtins.str]] = None,
                 manual: Optional[pulumi.Input['ConnectorGcpKmsManualArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ConnectorGcpKms resources.
        :param pulumi.Input[_builtins.bool] default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate.
        :param pulumi.Input[_builtins.str] gcp_project_id: The project ID of the GCP KMS.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] key_name: The key name of the GCP KMS.
        :param pulumi.Input[_builtins.str] key_ring: The key ring of the GCP KMS.
        :param pulumi.Input['ConnectorGcpKmsManualArgs'] manual: Manual credential configuration.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The region of the GCP KMS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_on_delegate is not None:
            pulumi.set(__self__, "execute_on_delegate", execute_on_delegate)
        if gcp_project_id is not None:
            pulumi.set(__self__, "gcp_project_id", gcp_project_id)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_ring is not None:
            pulumi.set(__self__, "key_ring", key_ring)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_authentications is not None:
            pulumi.set(__self__, "oidc_authentications", oidc_authentications)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @execute_on_delegate.setter
    def execute_on_delegate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "execute_on_delegate", value)

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID of the GCP KMS.
        """
        return pulumi.get(self, "gcp_project_id")

    @gcp_project_id.setter
    def gcp_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gcp_project_id", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key name of the GCP KMS.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key ring of the GCP KMS.
        """
        return pulumi.get(self, "key_ring")

    @key_ring.setter
    def key_ring(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_ring", value)

    @_builtins.property
    @pulumi.getter
    def manual(self) -> Optional[pulumi.Input['ConnectorGcpKmsManualArgs']]:
        """
        Manual credential configuration.
        """
        return pulumi.get(self, "manual")

    @manual.setter
    def manual(self, value: Optional[pulumi.Input['ConnectorGcpKmsManualArgs']]):
        pulumi.set(self, "manual", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @oidc_authentications.setter
    def oidc_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorGcpKmsOidcAuthenticationArgs']]]]):
        pulumi.set(self, "oidc_authentications", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the GCP KMS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("harness:platform/connectorGcpKms:ConnectorGcpKms")
class ConnectorGcpKms(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ring: Optional[pulumi.Input[_builtins.str]] = None,
                 manual: Optional[pulumi.Input[Union['ConnectorGcpKmsManualArgs', 'ConnectorGcpKmsManualArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorGcpKmsOidcAuthenticationArgs', 'ConnectorGcpKmsOidcAuthenticationArgsDict']]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for creating a GCP KMS connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.platform.SecretText("test",
            identifier="%[1]s",
            name="%[2]s",
            description="test",
            tags=["foo:bar"],
            secret_manager_identifier="harnessSecretManager",
            value_type="Reference",
            value="secret")
        gcp_kms_manual = harness.platform.ConnectorGcpKms("gcp_kms_manual",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            manual={
                "credentials": test.id.apply(lambda id: f"account.{id}"),
                "delegate_selectors": ["harness-delegate"],
            })
        gcp_kms_oidc_platform = harness.platform.ConnectorGcpKms("gcp_kms_oidc_platform",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            execute_on_delegate=False,
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
            }])
        gcp_kms_oidc_delegate = harness.platform.ConnectorGcpKms("gcp_kms_oidc_delegate",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
                "delegate_selectors": ["harness-delegate"],
            }])
        gcp_kms_oidc_delegate_default = harness.platform.ConnectorGcpKms("gcp_kms_oidc_delegate_default",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            default=True,
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
                "delegate_selectors": ["harness-delegate"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <connector_id>
        ```

        Import org level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <ord_id>/<connector_id>
        ```

        Import project level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate.
        :param pulumi.Input[_builtins.str] gcp_project_id: The project ID of the GCP KMS.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] key_name: The key name of the GCP KMS.
        :param pulumi.Input[_builtins.str] key_ring: The key ring of the GCP KMS.
        :param pulumi.Input[Union['ConnectorGcpKmsManualArgs', 'ConnectorGcpKmsManualArgsDict']] manual: Manual credential configuration.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorGcpKmsOidcAuthenticationArgs', 'ConnectorGcpKmsOidcAuthenticationArgsDict']]]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The region of the GCP KMS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorGcpKmsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a GCP KMS connector.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        test = harness.platform.SecretText("test",
            identifier="%[1]s",
            name="%[2]s",
            description="test",
            tags=["foo:bar"],
            secret_manager_identifier="harnessSecretManager",
            value_type="Reference",
            value="secret")
        gcp_kms_manual = harness.platform.ConnectorGcpKms("gcp_kms_manual",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            manual={
                "credentials": test.id.apply(lambda id: f"account.{id}"),
                "delegate_selectors": ["harness-delegate"],
            })
        gcp_kms_oidc_platform = harness.platform.ConnectorGcpKms("gcp_kms_oidc_platform",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            execute_on_delegate=False,
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
            }])
        gcp_kms_oidc_delegate = harness.platform.ConnectorGcpKms("gcp_kms_oidc_delegate",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
                "delegate_selectors": ["harness-delegate"],
            }])
        gcp_kms_oidc_delegate_default = harness.platform.ConnectorGcpKms("gcp_kms_oidc_delegate_default",
            identifier="identifier",
            name="name",
            description="test",
            tags=["foo:bar"],
            region="us-west1",
            gcp_project_id="1234567",
            key_ring="key_ring",
            key_name="key_name",
            default=True,
            oidc_authentications=[{
                "workload_pool_id": "harness-pool-test",
                "provider_id": "harness",
                "gcp_project_id": "1234567",
                "service_account_email": "harness.sample@iam.gserviceaccount.com",
                "delegate_selectors": ["harness-delegate"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import account level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <connector_id>
        ```

        Import org level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <ord_id>/<connector_id>
        ```

        Import project level gcp connector

        ```sh
        $ pulumi import harness:platform/connectorGcpKms:ConnectorGcpKms example <org_id>/<project_id>/<connector_id>
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorGcpKmsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorGcpKmsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
                 gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_ring: Optional[pulumi.Input[_builtins.str]] = None,
                 manual: Optional[pulumi.Input[Union['ConnectorGcpKmsManualArgs', 'ConnectorGcpKmsManualArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorGcpKmsOidcAuthenticationArgs', 'ConnectorGcpKmsOidcAuthenticationArgsDict']]]]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorGcpKmsArgs.__new__(ConnectorGcpKmsArgs)

            __props__.__dict__["default"] = default
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_on_delegate"] = execute_on_delegate
            if gcp_project_id is None and not opts.urn:
                raise TypeError("Missing required property 'gcp_project_id'")
            __props__.__dict__["gcp_project_id"] = gcp_project_id
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            if key_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_name'")
            __props__.__dict__["key_name"] = key_name
            if key_ring is None and not opts.urn:
                raise TypeError("Missing required property 'key_ring'")
            __props__.__dict__["key_ring"] = key_ring
            __props__.__dict__["manual"] = manual
            __props__.__dict__["name"] = name
            __props__.__dict__["oidc_authentications"] = oidc_authentications
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
        super(ConnectorGcpKms, __self__).__init__(
            'harness:platform/connectorGcpKms:ConnectorGcpKms',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            execute_on_delegate: Optional[pulumi.Input[_builtins.bool]] = None,
            gcp_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[_builtins.str]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_ring: Optional[pulumi.Input[_builtins.str]] = None,
            manual: Optional[pulumi.Input[Union['ConnectorGcpKmsManualArgs', 'ConnectorGcpKmsManualArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oidc_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorGcpKmsOidcAuthenticationArgs', 'ConnectorGcpKmsOidcAuthenticationArgsDict']]]]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ConnectorGcpKms':
        """
        Get an existing ConnectorGcpKms resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] default: Set this flag to set this secret manager as default secret manager.
        :param pulumi.Input[_builtins.str] description: Description of the resource.
        :param pulumi.Input[_builtins.bool] execute_on_delegate: Enable this flag to execute on Delegate.
        :param pulumi.Input[_builtins.str] gcp_project_id: The project ID of the GCP KMS.
        :param pulumi.Input[_builtins.str] identifier: Unique identifier of the resource.
        :param pulumi.Input[_builtins.str] key_name: The key name of the GCP KMS.
        :param pulumi.Input[_builtins.str] key_ring: The key ring of the GCP KMS.
        :param pulumi.Input[Union['ConnectorGcpKmsManualArgs', 'ConnectorGcpKmsManualArgsDict']] manual: Manual credential configuration.
        :param pulumi.Input[_builtins.str] name: Name of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorGcpKmsOidcAuthenticationArgs', 'ConnectorGcpKmsOidcAuthenticationArgsDict']]]] oidc_authentications: Authentication using harness oidc.
        :param pulumi.Input[_builtins.str] org_id: Unique identifier of the organization.
        :param pulumi.Input[_builtins.str] project_id: Unique identifier of the project.
        :param pulumi.Input[_builtins.str] region: The region of the GCP KMS.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to associate with the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorGcpKmsState.__new__(_ConnectorGcpKmsState)

        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_on_delegate"] = execute_on_delegate
        __props__.__dict__["gcp_project_id"] = gcp_project_id
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["key_ring"] = key_ring
        __props__.__dict__["manual"] = manual
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc_authentications"] = oidc_authentications
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        return ConnectorGcpKms(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set this flag to set this secret manager as default secret manager.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="executeOnDelegate")
    def execute_on_delegate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable this flag to execute on Delegate.
        """
        return pulumi.get(self, "execute_on_delegate")

    @_builtins.property
    @pulumi.getter(name="gcpProjectId")
    def gcp_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID of the GCP KMS.
        """
        return pulumi.get(self, "gcp_project_id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the resource.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        The key name of the GCP KMS.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyRing")
    def key_ring(self) -> pulumi.Output[_builtins.str]:
        """
        The key ring of the GCP KMS.
        """
        return pulumi.get(self, "key_ring")

    @_builtins.property
    @pulumi.getter
    def manual(self) -> pulumi.Output[Optional['outputs.ConnectorGcpKmsManual']]:
        """
        Manual credential configuration.
        """
        return pulumi.get(self, "manual")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oidcAuthentications")
    def oidc_authentications(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectorGcpKmsOidcAuthentication']]]:
        """
        Authentication using harness oidc.
        """
        return pulumi.get(self, "oidc_authentications")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the GCP KMS.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to associate with the resource.
        """
        return pulumi.get(self, "tags")

