# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHarRegistryResult',
    'AwaitableGetHarRegistryResult',
    'get_har_registry',
    'get_har_registry_output',
]

@pulumi.output_type
class GetHarRegistryResult:
    """
    A collection of values returned by getHarRegistry.
    """
    def __init__(__self__, allowed_patterns=None, blocked_patterns=None, configs=None, created_at=None, description=None, id=None, identifier=None, package_type=None, parent_ref=None, space_ref=None, url=None):
        if allowed_patterns and not isinstance(allowed_patterns, list):
            raise TypeError("Expected argument 'allowed_patterns' to be a list")
        pulumi.set(__self__, "allowed_patterns", allowed_patterns)
        if blocked_patterns and not isinstance(blocked_patterns, list):
            raise TypeError("Expected argument 'blocked_patterns' to be a list")
        pulumi.set(__self__, "blocked_patterns", blocked_patterns)
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if parent_ref and not isinstance(parent_ref, str):
            raise TypeError("Expected argument 'parent_ref' to be a str")
        pulumi.set(__self__, "parent_ref", parent_ref)
        if space_ref and not isinstance(space_ref, str):
            raise TypeError("Expected argument 'space_ref' to be a str")
        pulumi.set(__self__, "space_ref", space_ref)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="allowedPatterns")
    def allowed_patterns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Allowed artifact patterns
        """
        return pulumi.get(self, "allowed_patterns")

    @_builtins.property
    @pulumi.getter(name="blockedPatterns")
    def blocked_patterns(self) -> Optional[Sequence[_builtins.str]]:
        """
        Blocked artifact patterns
        """
        return pulumi.get(self, "blocked_patterns")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.GetHarRegistryConfigResult']]:
        """
        Configuration for the registry
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Creation timestamp
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the registry
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> _builtins.str:
        """
        Unique identifier of the registry
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[_builtins.str]:
        """
        Type of package (DOCKER, HELM, MAVEN, etc.)
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[_builtins.str]:
        """
        Parent reference for the registry
        """
        return pulumi.get(self, "parent_ref")

    @_builtins.property
    @pulumi.getter(name="spaceRef")
    def space_ref(self) -> Optional[_builtins.str]:
        """
        Space reference for the registry
        """
        return pulumi.get(self, "space_ref")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL of the registry
        """
        return pulumi.get(self, "url")


class AwaitableGetHarRegistryResult(GetHarRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHarRegistryResult(
            allowed_patterns=self.allowed_patterns,
            blocked_patterns=self.blocked_patterns,
            configs=self.configs,
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            identifier=self.identifier,
            package_type=self.package_type,
            parent_ref=self.parent_ref,
            space_ref=self.space_ref,
            url=self.url)


def get_har_registry(allowed_patterns: Optional[Sequence[_builtins.str]] = None,
                     blocked_patterns: Optional[Sequence[_builtins.str]] = None,
                     configs: Optional[Sequence[Union['GetHarRegistryConfigArgs', 'GetHarRegistryConfigArgsDict']]] = None,
                     description: Optional[_builtins.str] = None,
                     identifier: Optional[_builtins.str] = None,
                     package_type: Optional[_builtins.str] = None,
                     parent_ref: Optional[_builtins.str] = None,
                     space_ref: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHarRegistryResult:
    """
    Resource for creating and managing Harness Registries.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_har_registry(identifier="test_registry",
        space_ref="accountId/orgId/projectId")
    ```


    :param Sequence[_builtins.str] allowed_patterns: Allowed artifact patterns
    :param Sequence[_builtins.str] blocked_patterns: Blocked artifact patterns
    :param Sequence[Union['GetHarRegistryConfigArgs', 'GetHarRegistryConfigArgsDict']] configs: Configuration for the registry
    :param _builtins.str description: Description of the registry
    :param _builtins.str identifier: Unique identifier of the registry
    :param _builtins.str package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
    :param _builtins.str parent_ref: Parent reference for the registry
    :param _builtins.str space_ref: Space reference for the registry
    """
    __args__ = dict()
    __args__['allowedPatterns'] = allowed_patterns
    __args__['blockedPatterns'] = blocked_patterns
    __args__['configs'] = configs
    __args__['description'] = description
    __args__['identifier'] = identifier
    __args__['packageType'] = package_type
    __args__['parentRef'] = parent_ref
    __args__['spaceRef'] = space_ref
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:platform/getHarRegistry:getHarRegistry', __args__, opts=opts, typ=GetHarRegistryResult).value

    return AwaitableGetHarRegistryResult(
        allowed_patterns=pulumi.get(__ret__, 'allowed_patterns'),
        blocked_patterns=pulumi.get(__ret__, 'blocked_patterns'),
        configs=pulumi.get(__ret__, 'configs'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        package_type=pulumi.get(__ret__, 'package_type'),
        parent_ref=pulumi.get(__ret__, 'parent_ref'),
        space_ref=pulumi.get(__ret__, 'space_ref'),
        url=pulumi.get(__ret__, 'url'))
def get_har_registry_output(allowed_patterns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            blocked_patterns: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            configs: Optional[pulumi.Input[Optional[Sequence[Union['GetHarRegistryConfigArgs', 'GetHarRegistryConfigArgsDict']]]]] = None,
                            description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            identifier: Optional[pulumi.Input[_builtins.str]] = None,
                            package_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            parent_ref: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            space_ref: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHarRegistryResult]:
    """
    Resource for creating and managing Harness Registries.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    test = harness.platform.get_har_registry(identifier="test_registry",
        space_ref="accountId/orgId/projectId")
    ```


    :param Sequence[_builtins.str] allowed_patterns: Allowed artifact patterns
    :param Sequence[_builtins.str] blocked_patterns: Blocked artifact patterns
    :param Sequence[Union['GetHarRegistryConfigArgs', 'GetHarRegistryConfigArgsDict']] configs: Configuration for the registry
    :param _builtins.str description: Description of the registry
    :param _builtins.str identifier: Unique identifier of the registry
    :param _builtins.str package_type: Type of package (DOCKER, HELM, MAVEN, etc.)
    :param _builtins.str parent_ref: Parent reference for the registry
    :param _builtins.str space_ref: Space reference for the registry
    """
    __args__ = dict()
    __args__['allowedPatterns'] = allowed_patterns
    __args__['blockedPatterns'] = blocked_patterns
    __args__['configs'] = configs
    __args__['description'] = description
    __args__['identifier'] = identifier
    __args__['packageType'] = package_type
    __args__['parentRef'] = parent_ref
    __args__['spaceRef'] = space_ref
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:platform/getHarRegistry:getHarRegistry', __args__, opts=opts, typ=GetHarRegistryResult)
    return __ret__.apply(lambda __response__: GetHarRegistryResult(
        allowed_patterns=pulumi.get(__response__, 'allowed_patterns'),
        blocked_patterns=pulumi.get(__response__, 'blocked_patterns'),
        configs=pulumi.get(__response__, 'configs'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        identifier=pulumi.get(__response__, 'identifier'),
        package_type=pulumi.get(__response__, 'package_type'),
        parent_ref=pulumi.get(__response__, 'parent_ref'),
        space_ref=pulumi.get(__response__, 'space_ref'),
        url=pulumi.get(__response__, 'url')))
