# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiscoveryAgentResult',
    'AwaitableGetDiscoveryAgentResult',
    'get_discovery_agent',
    'get_discovery_agent_output',
]

@pulumi.output_type
class GetDiscoveryAgentResult:
    """
    A collection of values returned by getDiscoveryAgent.
    """
    def __init__(__self__, configs=None, correlation_id=None, created_at=None, created_by=None, description=None, environment_identifier=None, id=None, identity=None, installation_details=None, installation_type=None, name=None, network_map_count=None, org_identifier=None, permanent_installation=None, project_identifier=None, removed=None, removed_at=None, service_count=None, tags=None, updated_at=None, updated_by=None, webhook_url=None):
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if correlation_id and not isinstance(correlation_id, str):
            raise TypeError("Expected argument 'correlation_id' to be a str")
        pulumi.set(__self__, "correlation_id", correlation_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment_identifier and not isinstance(environment_identifier, str):
            raise TypeError("Expected argument 'environment_identifier' to be a str")
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, str):
            raise TypeError("Expected argument 'identity' to be a str")
        pulumi.set(__self__, "identity", identity)
        if installation_details and not isinstance(installation_details, list):
            raise TypeError("Expected argument 'installation_details' to be a list")
        pulumi.set(__self__, "installation_details", installation_details)
        if installation_type and not isinstance(installation_type, str):
            raise TypeError("Expected argument 'installation_type' to be a str")
        pulumi.set(__self__, "installation_type", installation_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_map_count and not isinstance(network_map_count, int):
            raise TypeError("Expected argument 'network_map_count' to be a int")
        pulumi.set(__self__, "network_map_count", network_map_count)
        if org_identifier and not isinstance(org_identifier, str):
            raise TypeError("Expected argument 'org_identifier' to be a str")
        pulumi.set(__self__, "org_identifier", org_identifier)
        if permanent_installation and not isinstance(permanent_installation, bool):
            raise TypeError("Expected argument 'permanent_installation' to be a bool")
        pulumi.set(__self__, "permanent_installation", permanent_installation)
        if project_identifier and not isinstance(project_identifier, str):
            raise TypeError("Expected argument 'project_identifier' to be a str")
        pulumi.set(__self__, "project_identifier", project_identifier)
        if removed and not isinstance(removed, bool):
            raise TypeError("Expected argument 'removed' to be a bool")
        pulumi.set(__self__, "removed", removed)
        if removed_at and not isinstance(removed_at, str):
            raise TypeError("Expected argument 'removed_at' to be a str")
        pulumi.set(__self__, "removed_at", removed_at)
        if service_count and not isinstance(service_count, int):
            raise TypeError("Expected argument 'service_count' to be a int")
        pulumi.set(__self__, "service_count", service_count)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if updated_by and not isinstance(updated_by, str):
            raise TypeError("Expected argument 'updated_by' to be a str")
        pulumi.set(__self__, "updated_by", updated_by)
        if webhook_url and not isinstance(webhook_url, str):
            raise TypeError("Expected argument 'webhook_url' to be a str")
        pulumi.set(__self__, "webhook_url", webhook_url)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetDiscoveryAgentConfigResult']:
        """
        Configuration for the agent.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> _builtins.str:
        """
        Correlation ID for the agent.
        """
        return pulumi.get(self, "correlation_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        User who created the agent.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> _builtins.str:
        """
        The environment identifier of the agent. This is a required field.
        """
        return pulumi.get(self, "environment_identifier")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the agent.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[_builtins.str]:
        """
        The unique identity of the agent. Either this or 'name' must be provided.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="installationDetails")
    def installation_details(self) -> Sequence['outputs.GetDiscoveryAgentInstallationDetailResult']:
        """
        Installation details of the agent.
        """
        return pulumi.get(self, "installation_details")

    @_builtins.property
    @pulumi.getter(name="installationType")
    def installation_type(self) -> _builtins.str:
        """
        Type of installation for the agent.
        """
        return pulumi.get(self, "installation_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the agent. Either this or 'identity' must be provided.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkMapCount")
    def network_map_count(self) -> _builtins.int:
        """
        Number of network maps associated with this agent.
        """
        return pulumi.get(self, "network_map_count")

    @_builtins.property
    @pulumi.getter(name="orgIdentifier")
    def org_identifier(self) -> Optional[_builtins.str]:
        """
        The organization identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "org_identifier")

    @_builtins.property
    @pulumi.getter(name="permanentInstallation")
    def permanent_installation(self) -> _builtins.bool:
        """
        Whether this is a permanent installation.
        """
        return pulumi.get(self, "permanent_installation")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[_builtins.str]:
        """
        The project identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
        """
        return pulumi.get(self, "project_identifier")

    @_builtins.property
    @pulumi.getter
    def removed(self) -> _builtins.bool:
        """
        Whether the agent has been removed.
        """
        return pulumi.get(self, "removed")

    @_builtins.property
    @pulumi.getter(name="removedAt")
    def removed_at(self) -> _builtins.str:
        """
        Timestamp when the agent was removed.
        """
        return pulumi.get(self, "removed_at")

    @_builtins.property
    @pulumi.getter(name="serviceCount")
    def service_count(self) -> _builtins.int:
        """
        Number of services managed by this agent.
        """
        return pulumi.get(self, "service_count")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Key-value list of resource tags for the agent.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Timestamp when the agent was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> _builtins.str:
        """
        User who last updated the agent.
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="webhookUrl")
    def webhook_url(self) -> _builtins.str:
        """
        Webhook URL for the agent.
        """
        return pulumi.get(self, "webhook_url")


class AwaitableGetDiscoveryAgentResult(GetDiscoveryAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoveryAgentResult(
            configs=self.configs,
            correlation_id=self.correlation_id,
            created_at=self.created_at,
            created_by=self.created_by,
            description=self.description,
            environment_identifier=self.environment_identifier,
            id=self.id,
            identity=self.identity,
            installation_details=self.installation_details,
            installation_type=self.installation_type,
            name=self.name,
            network_map_count=self.network_map_count,
            org_identifier=self.org_identifier,
            permanent_installation=self.permanent_installation,
            project_identifier=self.project_identifier,
            removed=self.removed,
            removed_at=self.removed_at,
            service_count=self.service_count,
            tags=self.tags,
            updated_at=self.updated_at,
            updated_by=self.updated_by,
            webhook_url=self.webhook_url)


def get_discovery_agent(environment_identifier: Optional[_builtins.str] = None,
                        identity: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        org_identifier: Optional[_builtins.str] = None,
                        project_identifier: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoveryAgentResult:
    """
    Data source for retrieving a Harness Service Discovery Agent.

    This data source allows you to fetch details of a Service Discovery Agent using either its unique identifier or name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch a specific agent by name
    by_name = harness.service.get_discovery_agent(name="example-agent",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByName", by_name)
    # Data source to fetch a specific agent by identity
    by_identity = harness.service.get_discovery_agent(identity="example-infra",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByIdentity", by_identity)
    ```


    :param _builtins.str environment_identifier: The environment identifier of the agent. This is a required field.
    :param _builtins.str identity: The unique identity of the agent. Either this or 'name' must be provided.
    :param _builtins.str name: The name of the agent. Either this or 'identity' must be provided.
    :param _builtins.str org_identifier: The organization identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
    :param _builtins.str project_identifier: The project identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
    """
    __args__ = dict()
    __args__['environmentIdentifier'] = environment_identifier
    __args__['identity'] = identity
    __args__['name'] = name
    __args__['orgIdentifier'] = org_identifier
    __args__['projectIdentifier'] = project_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:service/getDiscoveryAgent:getDiscoveryAgent', __args__, opts=opts, typ=GetDiscoveryAgentResult).value

    return AwaitableGetDiscoveryAgentResult(
        configs=pulumi.get(__ret__, 'configs'),
        correlation_id=pulumi.get(__ret__, 'correlation_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        environment_identifier=pulumi.get(__ret__, 'environment_identifier'),
        id=pulumi.get(__ret__, 'id'),
        identity=pulumi.get(__ret__, 'identity'),
        installation_details=pulumi.get(__ret__, 'installation_details'),
        installation_type=pulumi.get(__ret__, 'installation_type'),
        name=pulumi.get(__ret__, 'name'),
        network_map_count=pulumi.get(__ret__, 'network_map_count'),
        org_identifier=pulumi.get(__ret__, 'org_identifier'),
        permanent_installation=pulumi.get(__ret__, 'permanent_installation'),
        project_identifier=pulumi.get(__ret__, 'project_identifier'),
        removed=pulumi.get(__ret__, 'removed'),
        removed_at=pulumi.get(__ret__, 'removed_at'),
        service_count=pulumi.get(__ret__, 'service_count'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        updated_by=pulumi.get(__ret__, 'updated_by'),
        webhook_url=pulumi.get(__ret__, 'webhook_url'))
def get_discovery_agent_output(environment_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                               identity: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               org_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               project_identifier: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiscoveryAgentResult]:
    """
    Data source for retrieving a Harness Service Discovery Agent.

    This data source allows you to fetch details of a Service Discovery Agent using either its unique identifier or name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_harness as harness

    # Data source to fetch a specific agent by name
    by_name = harness.service.get_discovery_agent(name="example-agent",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByName", by_name)
    # Data source to fetch a specific agent by identity
    by_identity = harness.service.get_discovery_agent(identity="example-infra",
        org_identifier=org_identifier,
        project_identifier=project_identifier,
        environment_identifier=environment_identifier)
    pulumi.export("agentDetailsByIdentity", by_identity)
    ```


    :param _builtins.str environment_identifier: The environment identifier of the agent. This is a required field.
    :param _builtins.str identity: The unique identity of the agent. Either this or 'name' must be provided.
    :param _builtins.str name: The name of the agent. Either this or 'identity' must be provided.
    :param _builtins.str org_identifier: The organization identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
    :param _builtins.str project_identifier: The project identifier of the agent (optional). Must be 1-64 characters and contain only alphanumeric characters, hyphens, or underscores.
    """
    __args__ = dict()
    __args__['environmentIdentifier'] = environment_identifier
    __args__['identity'] = identity
    __args__['name'] = name
    __args__['orgIdentifier'] = org_identifier
    __args__['projectIdentifier'] = project_identifier
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('harness:service/getDiscoveryAgent:getDiscoveryAgent', __args__, opts=opts, typ=GetDiscoveryAgentResult)
    return __ret__.apply(lambda __response__: GetDiscoveryAgentResult(
        configs=pulumi.get(__response__, 'configs'),
        correlation_id=pulumi.get(__response__, 'correlation_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        environment_identifier=pulumi.get(__response__, 'environment_identifier'),
        id=pulumi.get(__response__, 'id'),
        identity=pulumi.get(__response__, 'identity'),
        installation_details=pulumi.get(__response__, 'installation_details'),
        installation_type=pulumi.get(__response__, 'installation_type'),
        name=pulumi.get(__response__, 'name'),
        network_map_count=pulumi.get(__response__, 'network_map_count'),
        org_identifier=pulumi.get(__response__, 'org_identifier'),
        permanent_installation=pulumi.get(__response__, 'permanent_installation'),
        project_identifier=pulumi.get(__response__, 'project_identifier'),
        removed=pulumi.get(__response__, 'removed'),
        removed_at=pulumi.get(__response__, 'removed_at'),
        service_count=pulumi.get(__response__, 'service_count'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        updated_by=pulumi.get(__response__, 'updated_by'),
        webhook_url=pulumi.get(__response__, 'webhook_url')))
