# keplar_api
API documentation using Swagger

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.0.24
- Generator version: 7.16.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import keplar_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import keplar_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import keplar_api
from keplar_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:3000
# See configuration.py for a list of all supported configuration parameters.
configuration = keplar_api.Configuration(
    host = "http://localhost:3000"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = keplar_api.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with keplar_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = keplar_api.DefaultApi(api_client)
    workspace_id = 'workspace_id_example' # str | 
    add_workspace_member_request = keplar_api.AddWorkspaceMemberRequest() # AddWorkspaceMemberRequest | 

    try:
        # Add workspace member
        api_response = await api_instance.add_workspace_member(workspace_id, add_workspace_member_request)
        print("The response of DefaultApi->add_workspace_member:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->add_workspace_member: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**add_workspace_member**](docs/DefaultApi.md#add_workspace_member) | **POST** /api/workspaces/{workspaceId}/members | Add workspace member
*DefaultApi* | [**api_auth_google_get**](docs/DefaultApi.md#api_auth_google_get) | **GET** /api/auth/google | 
*DefaultApi* | [**api_auth_google_redirect_get**](docs/DefaultApi.md#api_auth_google_redirect_get) | **GET** /api/auth/google/redirect | 
*DefaultApi* | [**api_call_messages_search_post**](docs/DefaultApi.md#api_call_messages_search_post) | **POST** /api/callMessages/search | Search conversation messages
*DefaultApi* | [**api_calls_call_id_get**](docs/DefaultApi.md#api_calls_call_id_get) | **GET** /api/calls/{callId} | Get call
*DefaultApi* | [**api_calls_call_id_messages_index_get**](docs/DefaultApi.md#api_calls_call_id_messages_index_get) | **GET** /api/calls/{callId}/messages/{index} | Get conversation message
*DefaultApi* | [**api_copilotkit_post**](docs/DefaultApi.md#api_copilotkit_post) | **POST** /api/copilotkit | 
*DefaultApi* | [**api_demos_create_demo_invite_post**](docs/DefaultApi.md#api_demos_create_demo_invite_post) | **POST** /api/demos/createDemoInvite | Create demo invite
*DefaultApi* | [**api_files_file_id_delete**](docs/DefaultApi.md#api_files_file_id_delete) | **DELETE** /api/files/{fileId} | Delete a file
*DefaultApi* | [**api_files_file_id_get**](docs/DefaultApi.md#api_files_file_id_get) | **GET** /api/files/{fileId} | Get file metadata
*DefaultApi* | [**api_files_file_id_signed_url_post**](docs/DefaultApi.md#api_files_file_id_signed_url_post) | **POST** /api/files/{fileId}/signed-url | Get a signed URL for file access
*DefaultApi* | [**api_files_post**](docs/DefaultApi.md#api_files_post) | **POST** /api/files/ | Upload a file
*DefaultApi* | [**api_invite_code_code_participant_code_participant_code_join_get**](docs/DefaultApi.md#api_invite_code_code_participant_code_participant_code_join_get) | **GET** /api/inviteCode/{code}/participantCode/{participantCode}/join | 
*DefaultApi* | [**api_invite_code_code_start_get**](docs/DefaultApi.md#api_invite_code_code_start_get) | **GET** /api/inviteCode/{code}/start | 
*DefaultApi* | [**api_invites_id_get**](docs/DefaultApi.md#api_invites_id_get) | **GET** /api/invites/{id} | Get invite
*DefaultApi* | [**api_invites_id_participant_invites_get**](docs/DefaultApi.md#api_invites_id_participant_invites_get) | **GET** /api/invites/{id}/participantInvites | Get participant invites
*DefaultApi* | [**api_invites_id_participant_invites_participant_id_get**](docs/DefaultApi.md#api_invites_id_participant_invites_participant_id_get) | **GET** /api/invites/{id}/participantInvites/{participantId} | Get participant invite
*DefaultApi* | [**api_invites_id_participant_invites_participant_id_put**](docs/DefaultApi.md#api_invites_id_participant_invites_participant_id_put) | **PUT** /api/invites/{id}/participantInvites/{participantId} | Update participant invite
*DefaultApi* | [**api_invites_id_participant_invites_post**](docs/DefaultApi.md#api_invites_id_participant_invites_post) | **POST** /api/invites/{id}/participantInvites | Create participant invite
*DefaultApi* | [**api_invites_id_participants_participant_id_call_metadata_get**](docs/DefaultApi.md#api_invites_id_participants_participant_id_call_metadata_get) | **GET** /api/invites/{id}/participants/{participantId}/callMetadata | Get call metadata by invite ID and participant ID
*DefaultApi* | [**api_invites_id_put**](docs/DefaultApi.md#api_invites_id_put) | **PUT** /api/invites/{id}/ | Update invite
*DefaultApi* | [**api_invites_id_response_attribute_stats_get**](docs/DefaultApi.md#api_invites_id_response_attribute_stats_get) | **GET** /api/invites/{id}/responseAttributeStats | Get invite response attribute stats
*DefaultApi* | [**api_invites_id_responses_get**](docs/DefaultApi.md#api_invites_id_responses_get) | **GET** /api/invites/{id}/responses | Get invite responses
*DefaultApi* | [**api_invites_id_responses_post**](docs/DefaultApi.md#api_invites_id_responses_post) | **POST** /api/invites/{id}/responses | Create invite response
*DefaultApi* | [**api_invites_id_responses_response_id_call_metadata_get**](docs/DefaultApi.md#api_invites_id_responses_response_id_call_metadata_get) | **GET** /api/invites/{id}/responses/{responseId}/callMetadata | Get call metadata by invite ID and response ID
*DefaultApi* | [**api_invites_id_responses_response_id_get**](docs/DefaultApi.md#api_invites_id_responses_response_id_get) | **GET** /api/invites/{id}/responses/{responseId} | Get invite response
*DefaultApi* | [**api_invites_id_responses_response_id_put**](docs/DefaultApi.md#api_invites_id_responses_response_id_put) | **PUT** /api/invites/{id}/responses/{responseId} | Update invite response
*DefaultApi* | [**api_invites_post**](docs/DefaultApi.md#api_invites_post) | **POST** /api/invites/ | Create invite
*DefaultApi* | [**api_projects_draft_get**](docs/DefaultApi.md#api_projects_draft_get) | **GET** /api/projects/draft | Get draft project
*DefaultApi* | [**api_projects_post**](docs/DefaultApi.md#api_projects_post) | **POST** /api/projects/ | Create project
*DefaultApi* | [**api_projects_project_id_analysis_post**](docs/DefaultApi.md#api_projects_project_id_analysis_post) | **POST** /api/projects/{projectId}/analysis | Create project analysis
*DefaultApi* | [**api_projects_project_id_delete_post**](docs/DefaultApi.md#api_projects_project_id_delete_post) | **POST** /api/projects/{projectId}/delete | Delete or archive project
*DefaultApi* | [**api_projects_project_id_files_file_id_delete**](docs/DefaultApi.md#api_projects_project_id_files_file_id_delete) | **DELETE** /api/projects/{projectId}/files/{fileId} | Remove a file from a project
*DefaultApi* | [**api_projects_project_id_files_file_id_put**](docs/DefaultApi.md#api_projects_project_id_files_file_id_put) | **PUT** /api/projects/{projectId}/files/{fileId} | Update project file metadata
*DefaultApi* | [**api_projects_project_id_files_get**](docs/DefaultApi.md#api_projects_project_id_files_get) | **GET** /api/projects/{projectId}/files | Get files for a project
*DefaultApi* | [**api_projects_project_id_files_post**](docs/DefaultApi.md#api_projects_project_id_files_post) | **POST** /api/projects/{projectId}/files | Add an existing file to a project
*DefaultApi* | [**api_projects_project_id_launch_post**](docs/DefaultApi.md#api_projects_project_id_launch_post) | **POST** /api/projects/{projectId}/launch | Launch project
*DefaultApi* | [**api_projects_project_id_put**](docs/DefaultApi.md#api_projects_project_id_put) | **PUT** /api/projects/{projectId} | Update project
*DefaultApi* | [**api_projects_project_id_search_transcripts_post**](docs/DefaultApi.md#api_projects_project_id_search_transcripts_post) | **POST** /api/projects/{projectId}/searchTranscripts | Search project transcripts
*DefaultApi* | [**api_threads_get**](docs/DefaultApi.md#api_threads_get) | **GET** /api/threads/ | Get threads
*DefaultApi* | [**api_threads_thread_id_files_get**](docs/DefaultApi.md#api_threads_thread_id_files_get) | **GET** /api/threads/{threadId}/files | Get thread files
*DefaultApi* | [**api_threads_thread_id_post**](docs/DefaultApi.md#api_threads_thread_id_post) | **POST** /api/threads/{threadId} | Upsert thread
*DefaultApi* | [**api_threads_thread_id_project_brief_versions_get**](docs/DefaultApi.md#api_threads_thread_id_project_brief_versions_get) | **GET** /api/threads/{threadId}/project-brief-versions | Get project brief versions from thread state history
*DefaultApi* | [**api_threads_thread_id_project_brief_versions_post**](docs/DefaultApi.md#api_threads_thread_id_project_brief_versions_post) | **POST** /api/threads/{threadId}/project-brief-versions | Create project draft versions from thread state history
*DefaultApi* | [**api_users_id_get**](docs/DefaultApi.md#api_users_id_get) | **GET** /api/users/{id} | Get user
*DefaultApi* | [**api_vapi_webhook_post**](docs/DefaultApi.md#api_vapi_webhook_post) | **POST** /api/vapi/webhook | 
*DefaultApi* | [**create_artifact**](docs/DefaultApi.md#create_artifact) | **POST** /api/projects/{projectId}/artifacts | Create artifact
*DefaultApi* | [**create_code_invite_response**](docs/DefaultApi.md#create_code_invite_response) | **POST** /api/inviteCode/{code}/responses | Create invite response for invite code
*DefaultApi* | [**create_code_invite_response_from_existing**](docs/DefaultApi.md#create_code_invite_response_from_existing) | **POST** /api/inviteCode/{code}/responses/{responseId}/createNewResponse | Create invite response from existing response
*DefaultApi* | [**create_email_share**](docs/DefaultApi.md#create_email_share) | **POST** /api/sharing/share-entities/{shareEntityId}/emails | Add email access to a share
*DefaultApi* | [**create_project_preview_invite**](docs/DefaultApi.md#create_project_preview_invite) | **POST** /api/projects/{projectId}/previewInvite | Create a preview invite for this project based on audienceSettings
*DefaultApi* | [**create_project_share**](docs/DefaultApi.md#create_project_share) | **POST** /api/sharing/projects/{projectId} | Create a share link for a project
*DefaultApi* | [**create_test_participant_code_invite**](docs/DefaultApi.md#create_test_participant_code_invite) | **POST** /api/inviteCode/{code}/participantCode/{participantCode}/test | Create test invite for participant
*DefaultApi* | [**create_transcript_insight_for_code_invite_response**](docs/DefaultApi.md#create_transcript_insight_for_code_invite_response) | **POST** /api/inviteCode/{code}/responses/{responseId}/transcriptInsight | Create transcript insight for invite response
*DefaultApi* | [**create_workspace**](docs/DefaultApi.md#create_workspace) | **POST** /api/workspaces/ | Create workspace
*DefaultApi* | [**delete_artifact**](docs/DefaultApi.md#delete_artifact) | **DELETE** /api/projects/{projectId}/artifacts/{artifactId} | Delete artifact
*DefaultApi* | [**delete_email_share**](docs/DefaultApi.md#delete_email_share) | **DELETE** /api/sharing/share-entities/{shareEntityId}/emails/{email} | Remove email access from a share
*DefaultApi* | [**download_invite_responses**](docs/DefaultApi.md#download_invite_responses) | **GET** /api/invites/{id}/responses/download | Download invite responses as CSV
*DefaultApi* | [**download_share_invite_responses**](docs/DefaultApi.md#download_share_invite_responses) | **GET** /api/share/{shareToken}/invites/{inviteId}/responses/download | Download invite responses as CSV
*DefaultApi* | [**get_artifact**](docs/DefaultApi.md#get_artifact) | **GET** /api/projects/{projectId}/artifacts/{artifactId} | Get artifact by ID
*DefaultApi* | [**get_artifact_version_groups**](docs/DefaultApi.md#get_artifact_version_groups) | **GET** /api/projects/{projectId}/artifacts | Get project artifact version groups
*DefaultApi* | [**get_call_metadata_for_code_invite_response**](docs/DefaultApi.md#get_call_metadata_for_code_invite_response) | **GET** /api/inviteCode/{code}/responses/{responseId}/callMetadata | Get call metadata for invite response
*DefaultApi* | [**get_code_invite**](docs/DefaultApi.md#get_code_invite) | **GET** /api/inviteCode/{code}/ | Get invite by code
*DefaultApi* | [**get_code_invite_participant_remaining_responses**](docs/DefaultApi.md#get_code_invite_participant_remaining_responses) | **GET** /api/inviteCode/{code}/remainingResponses | Get remaining responses count for participant
*DefaultApi* | [**get_code_invite_participant_response**](docs/DefaultApi.md#get_code_invite_participant_response) | **GET** /api/inviteCode/{code}/participantResponse | Get invite response for participant
*DefaultApi* | [**get_code_invite_response**](docs/DefaultApi.md#get_code_invite_response) | **GET** /api/inviteCode/{code}/responses/{responseId} | Get invite response
*DefaultApi* | [**get_code_invite_response_redirect**](docs/DefaultApi.md#get_code_invite_response_redirect) | **GET** /api/inviteCode/{code}/responses/{responseId}/redirect | Get redirect URL for invite response
*DefaultApi* | [**get_code_participant_invite**](docs/DefaultApi.md#get_code_participant_invite) | **GET** /api/inviteCode/{code}/participantCode/{participantCode} | Get participant invite for invite code
*DefaultApi* | [**get_project**](docs/DefaultApi.md#get_project) | **GET** /api/projects/{projectId} | Get project
*DefaultApi* | [**get_project_response_attribute_stats**](docs/DefaultApi.md#get_project_response_attribute_stats) | **GET** /api/projects/{projectId}/responseAttributeStats | Get project response attribute stats
*DefaultApi* | [**get_project_responses_metadata**](docs/DefaultApi.md#get_project_responses_metadata) | **GET** /api/projects/{projectId}/responsesMetadata | Get project responses metadata
*DefaultApi* | [**get_project_shares**](docs/DefaultApi.md#get_project_shares) | **GET** /api/projects/{projectId}/shares | Get all shares for a project
*DefaultApi* | [**get_projects**](docs/DefaultApi.md#get_projects) | **GET** /api/projects/ | Get projects
*DefaultApi* | [**get_share_entities**](docs/DefaultApi.md#get_share_entities) | **GET** /api/sharing/share-entities | List all share entities created by the user
*DefaultApi* | [**get_shared_artifact**](docs/DefaultApi.md#get_shared_artifact) | **GET** /api/share/{shareToken}/artifacts/{artifactId} | Get shared artifact by ID
*DefaultApi* | [**get_shared_artifact_version_groups**](docs/DefaultApi.md#get_shared_artifact_version_groups) | **GET** /api/share/{shareToken}/artifacts | Get shared project artifacts version groups
*DefaultApi* | [**get_shared_call**](docs/DefaultApi.md#get_shared_call) | **GET** /api/share/{shareToken}/calls/{callId} | Get shared call data with conversation messages
*DefaultApi* | [**get_shared_call_metadata**](docs/DefaultApi.md#get_shared_call_metadata) | **GET** /api/share/{shareToken}/invites/{inviteId}/responses/{responseId}/callMetadata | Get shared call metadata by invite ID and response ID
*DefaultApi* | [**get_shared_invite_response_attribute_stats**](docs/DefaultApi.md#get_shared_invite_response_attribute_stats) | **GET** /api/share/{shareToken}/invites/{inviteId}/response-attribute-stats | Get attribute stats for shared invite responses
*DefaultApi* | [**get_shared_invite_responses**](docs/DefaultApi.md#get_shared_invite_responses) | **GET** /api/share/{shareToken}/invites/{inviteId}/responses | Get responses for a shared invite
*DefaultApi* | [**get_shared_project**](docs/DefaultApi.md#get_shared_project) | **GET** /api/share/{shareToken}/project | Get shared project data
*DefaultApi* | [**get_shared_project_response_attribute_stats**](docs/DefaultApi.md#get_shared_project_response_attribute_stats) | **GET** /api/share/{shareToken}/project-response-attribute-stats | Get shared project response attribute stats
*DefaultApi* | [**get_shared_project_responses_metadata**](docs/DefaultApi.md#get_shared_project_responses_metadata) | **GET** /api/share/{shareToken}/project-responses-metadata | Get shared project responses metadata
*DefaultApi* | [**get_workspace_members**](docs/DefaultApi.md#get_workspace_members) | **GET** /api/workspaces/{workspaceId}/members | Get workspace members
*DefaultApi* | [**get_workspaces**](docs/DefaultApi.md#get_workspaces) | **GET** /api/workspaces/ | Get all workspaces
*DefaultApi* | [**join_code_invite**](docs/DefaultApi.md#join_code_invite) | **GET** /api/inviteCode/{code}/join | Join invite by code
*DefaultApi* | [**join_participant_code_invite**](docs/DefaultApi.md#join_participant_code_invite) | **GET** /api/inviteCode/{code}/participantCode/{participantCode}/start | Join invite by code and participant code
*DefaultApi* | [**login**](docs/DefaultApi.md#login) | **POST** /api/auth/login | Login with email and password
*DefaultApi* | [**logout**](docs/DefaultApi.md#logout) | **POST** /api/auth/logout | Logout user
*DefaultApi* | [**remove_workspace_member**](docs/DefaultApi.md#remove_workspace_member) | **DELETE** /api/workspaces/{workspaceId}/members/{memberId} | Remove workspace member
*DefaultApi* | [**request_magic_link**](docs/DefaultApi.md#request_magic_link) | **POST** /api/auth/send-magic-link | Request magic link for passwordless login
*DefaultApi* | [**request_password_reset**](docs/DefaultApi.md#request_password_reset) | **POST** /api/auth/send-reset-password-email | Request password reset email
*DefaultApi* | [**request_share_access**](docs/DefaultApi.md#request_share_access) | **POST** /api/share/{shareToken}/request-access | Request access to a share by email
*DefaultApi* | [**resend_verification**](docs/DefaultApi.md#resend_verification) | **POST** /api/auth/send-verification-email | Resend email verification
*DefaultApi* | [**reset_password**](docs/DefaultApi.md#reset_password) | **POST** /api/auth/update-password | Reset password with token
*DefaultApi* | [**search_response_messages**](docs/DefaultApi.md#search_response_messages) | **POST** /api/projects/{projectId}/searchResponseMessages | Search response messages by inviteResponseId and messageIndex
*DefaultApi* | [**search_shared_response_messages**](docs/DefaultApi.md#search_shared_response_messages) | **POST** /api/share/{shareToken}/search-response-messages | Search shared response messages by responseId and messageIndex
*DefaultApi* | [**signup**](docs/DefaultApi.md#signup) | **POST** /api/auth/signup | Sign up with email and password
*DefaultApi* | [**start_call_for_code_invite_response**](docs/DefaultApi.md#start_call_for_code_invite_response) | **GET** /api/inviteCode/{code}/responses/{responseId}/startCall | Start call for invite response
*DefaultApi* | [**start_phone_call_for_code_invite_response**](docs/DefaultApi.md#start_phone_call_for_code_invite_response) | **POST** /api/inviteCode/{code}/responses/{responseId}/startPhoneCall | Start phone call for invite response
*DefaultApi* | [**update_artifact**](docs/DefaultApi.md#update_artifact) | **PUT** /api/projects/{projectId}/artifacts/{artifactId} | Update artifact
*DefaultApi* | [**update_call_for_code_invite_response**](docs/DefaultApi.md#update_call_for_code_invite_response) | **PUT** /api/inviteCode/{code}/responses/{responseId}/updateCall | Update call for invite response
*DefaultApi* | [**update_code_invite_response**](docs/DefaultApi.md#update_code_invite_response) | **PUT** /api/inviteCode/{code}/responses/{responseId} | Update invite response
*DefaultApi* | [**update_share_entity**](docs/DefaultApi.md#update_share_entity) | **PUT** /api/sharing/share-entities/{shareEntityId} | Update a share entity
*DefaultApi* | [**update_workspace_member**](docs/DefaultApi.md#update_workspace_member) | **PUT** /api/workspaces/{workspaceId}/members/{memberId} | Update workspace member
*DefaultApi* | [**verify_email**](docs/DefaultApi.md#verify_email) | **POST** /api/auth/verify-email | Verify email address with token
*DefaultApi* | [**verify_email_access_for_share**](docs/DefaultApi.md#verify_email_access_for_share) | **POST** /api/share/{shareToken}/verify | Verify email access for a share
*DefaultApi* | [**verify_magic_link**](docs/DefaultApi.md#verify_magic_link) | **POST** /api/auth/verify-magic-link | Verify magic link token


## Documentation For Models

 - [AddWorkspaceMemberRequest](docs/AddWorkspaceMemberRequest.md)
 - [ApiDemosCreateDemoInvitePostRequest](docs/ApiDemosCreateDemoInvitePostRequest.md)
 - [ApiFilesFileIdSignedUrlPost200Response](docs/ApiFilesFileIdSignedUrlPost200Response.md)
 - [ApiFilesFileIdSignedUrlPostRequest](docs/ApiFilesFileIdSignedUrlPostRequest.md)
 - [ApiInvitesIdParticipantInvitesGet200Response](docs/ApiInvitesIdParticipantInvitesGet200Response.md)
 - [ApiInvitesIdParticipantInvitesParticipantIdPutRequest](docs/ApiInvitesIdParticipantInvitesParticipantIdPutRequest.md)
 - [ApiInvitesIdParticipantInvitesPostRequest](docs/ApiInvitesIdParticipantInvitesPostRequest.md)
 - [ApiInvitesIdParticipantInvitesPostRequestParticipant](docs/ApiInvitesIdParticipantInvitesPostRequestParticipant.md)
 - [ApiInvitesIdPutRequest](docs/ApiInvitesIdPutRequest.md)
 - [ApiInvitesIdResponsesPostRequest](docs/ApiInvitesIdResponsesPostRequest.md)
 - [ApiInvitesIdResponsesResponseIdPutRequest](docs/ApiInvitesIdResponsesResponseIdPutRequest.md)
 - [ApiInvitesPostRequest](docs/ApiInvitesPostRequest.md)
 - [ApiProjectsPostRequest](docs/ApiProjectsPostRequest.md)
 - [ApiProjectsPostRequestThreadAssetsInner](docs/ApiProjectsPostRequestThreadAssetsInner.md)
 - [ApiProjectsProjectIdAnalysisPost200Response](docs/ApiProjectsProjectIdAnalysisPost200Response.md)
 - [ApiProjectsProjectIdAnalysisPostRequest](docs/ApiProjectsProjectIdAnalysisPostRequest.md)
 - [ApiProjectsProjectIdFilesFileIdPutRequest](docs/ApiProjectsProjectIdFilesFileIdPutRequest.md)
 - [ApiProjectsProjectIdFilesGet200Response](docs/ApiProjectsProjectIdFilesGet200Response.md)
 - [ApiProjectsProjectIdFilesPostRequest](docs/ApiProjectsProjectIdFilesPostRequest.md)
 - [ApiProjectsProjectIdPutRequest](docs/ApiProjectsProjectIdPutRequest.md)
 - [ApiProjectsProjectIdSearchTranscriptsPostRequest](docs/ApiProjectsProjectIdSearchTranscriptsPostRequest.md)
 - [ApiThreadsGet200Response](docs/ApiThreadsGet200Response.md)
 - [ApiThreadsThreadIdFilesGet200Response](docs/ApiThreadsThreadIdFilesGet200Response.md)
 - [ApiThreadsThreadIdPostRequest](docs/ApiThreadsThreadIdPostRequest.md)
 - [ApiThreadsThreadIdProjectBriefVersionsGet200Response](docs/ApiThreadsThreadIdProjectBriefVersionsGet200Response.md)
 - [Artifact](docs/Artifact.md)
 - [ArtifactData](docs/ArtifactData.md)
 - [ArtifactDataCreate](docs/ArtifactDataCreate.md)
 - [ArtifactDataReport](docs/ArtifactDataReport.md)
 - [ArtifactDataThematicAnalysis](docs/ArtifactDataThematicAnalysis.md)
 - [ArtifactDataThematicAnalysisData](docs/ArtifactDataThematicAnalysisData.md)
 - [ArtifactDataThematicAnalysisDataThemesInner](docs/ArtifactDataThematicAnalysisDataThemesInner.md)
 - [ArtifactKind](docs/ArtifactKind.md)
 - [ArtifactMetadata](docs/ArtifactMetadata.md)
 - [ArtifactVersionGroup](docs/ArtifactVersionGroup.md)
 - [Attribute](docs/Attribute.md)
 - [AttributeFilterGroupSchemaInner](docs/AttributeFilterGroupSchemaInner.md)
 - [AttributeKind](docs/AttributeKind.md)
 - [AttributeKindGroup](docs/AttributeKindGroup.md)
 - [AttributeKindGroupPurpose](docs/AttributeKindGroupPurpose.md)
 - [AttributeKindGroupScope](docs/AttributeKindGroupScope.md)
 - [AttributeStatsSchemaInner](docs/AttributeStatsSchemaInner.md)
 - [AttributeStatsSchemaInnerGroup](docs/AttributeStatsSchemaInnerGroup.md)
 - [AttributeStatsSchemaInnerKind](docs/AttributeStatsSchemaInnerKind.md)
 - [AttributeStatsSchemaInnerValuesInner](docs/AttributeStatsSchemaInnerValuesInner.md)
 - [AttributeValueKind](docs/AttributeValueKind.md)
 - [BadRequestErrorResponse](docs/BadRequestErrorResponse.md)
 - [ByoPanelRepdataConfig](docs/ByoPanelRepdataConfig.md)
 - [Call](docs/Call.md)
 - [CallAnalysis](docs/CallAnalysis.md)
 - [CallEvent](docs/CallEvent.md)
 - [CallKind](docs/CallKind.md)
 - [CallMetadata](docs/CallMetadata.md)
 - [CallStatus](docs/CallStatus.md)
 - [CallSummary](docs/CallSummary.md)
 - [ChatCompletionTool](docs/ChatCompletionTool.md)
 - [ChatCompletionToolFunction](docs/ChatCompletionToolFunction.md)
 - [ChatMessage](docs/ChatMessage.md)
 - [ChatMessageKind](docs/ChatMessageKind.md)
 - [ChatMessageRole](docs/ChatMessageRole.md)
 - [ChatSession](docs/ChatSession.md)
 - [Citation](docs/Citation.md)
 - [CodeInvite](docs/CodeInvite.md)
 - [CodeInviteConfig](docs/CodeInviteConfig.md)
 - [CodeInviteConfigContacts](docs/CodeInviteConfigContacts.md)
 - [CodeInviteConfigKeplarPanel](docs/CodeInviteConfigKeplarPanel.md)
 - [CodeInviteResponse](docs/CodeInviteResponse.md)
 - [ConversationMessage](docs/ConversationMessage.md)
 - [ConversationMessageTopic](docs/ConversationMessageTopic.md)
 - [CreateArtifactRequest](docs/CreateArtifactRequest.md)
 - [CreateCodeInviteResponseRequest](docs/CreateCodeInviteResponseRequest.md)
 - [CreateEmailShareRequest](docs/CreateEmailShareRequest.md)
 - [CreateProjectPreviewInvite201Response](docs/CreateProjectPreviewInvite201Response.md)
 - [CreateProjectPreviewInviteRequest](docs/CreateProjectPreviewInviteRequest.md)
 - [CreateProjectShareRequest](docs/CreateProjectShareRequest.md)
 - [CreateProjectShareResponse](docs/CreateProjectShareResponse.md)
 - [CreateWorkspaceRequest](docs/CreateWorkspaceRequest.md)
 - [DeleteArtifact200Response](docs/DeleteArtifact200Response.md)
 - [EmailShare](docs/EmailShare.md)
 - [Evidence](docs/Evidence.md)
 - [FeatureConfig](docs/FeatureConfig.md)
 - [File](docs/File.md)
 - [FileMimeType](docs/FileMimeType.md)
 - [ForbiddenErrorResponse](docs/ForbiddenErrorResponse.md)
 - [GetCodeInvite200Response](docs/GetCodeInvite200Response.md)
 - [GetCodeInviteResponseRedirect200Response](docs/GetCodeInviteResponseRedirect200Response.md)
 - [GetProjectShares200Response](docs/GetProjectShares200Response.md)
 - [GetProjects200Response](docs/GetProjects200Response.md)
 - [GetSharedArtifactVersionGroups200Response](docs/GetSharedArtifactVersionGroups200Response.md)
 - [GetSharedInviteResponses200Response](docs/GetSharedInviteResponses200Response.md)
 - [GetWorkspaceMembers200Response](docs/GetWorkspaceMembers200Response.md)
 - [GetWorkspaces200Response](docs/GetWorkspaces200Response.md)
 - [GetWorkspaces200ResponseItemsInner](docs/GetWorkspaces200ResponseItemsInner.md)
 - [InboundCallResponse](docs/InboundCallResponse.md)
 - [InternalServerErrorResponse](docs/InternalServerErrorResponse.md)
 - [Invite](docs/Invite.md)
 - [InviteConfig](docs/InviteConfig.md)
 - [InviteConfigByoPanel](docs/InviteConfigByoPanel.md)
 - [InviteConfigContacts](docs/InviteConfigContacts.md)
 - [InviteConfigKeplarPanel](docs/InviteConfigKeplarPanel.md)
 - [InviteConfigPublic](docs/InviteConfigPublic.md)
 - [InviteResponse](docs/InviteResponse.md)
 - [InviteResponseAttribute](docs/InviteResponseAttribute.md)
 - [InviteResponseAttributeData](docs/InviteResponseAttributeData.md)
 - [InviteResponseData](docs/InviteResponseData.md)
 - [InviteResponseKind](docs/InviteResponseKind.md)
 - [InviteResponseMetadata](docs/InviteResponseMetadata.md)
 - [InviteResponseShareConfig](docs/InviteResponseShareConfig.md)
 - [InviteResponseStatus](docs/InviteResponseStatus.md)
 - [InviteResponseUpdateEvent](docs/InviteResponseUpdateEvent.md)
 - [InviteResponseWithCallSummary](docs/InviteResponseWithCallSummary.md)
 - [InviteResponseWithMetadata](docs/InviteResponseWithMetadata.md)
 - [InviteResponseWithMetadataAttributesInner](docs/InviteResponseWithMetadataAttributesInner.md)
 - [InviteResponseWithMetadataAttributesInnerEvidence](docs/InviteResponseWithMetadataAttributesInnerEvidence.md)
 - [InviteStatus](docs/InviteStatus.md)
 - [InviteWithAnalytics](docs/InviteWithAnalytics.md)
 - [JoinCodeInvite302Response](docs/JoinCodeInvite302Response.md)
 - [JoinCodeInvite302ResponseSettings](docs/JoinCodeInvite302ResponseSettings.md)
 - [Login200Response](docs/Login200Response.md)
 - [Login200ResponseAnyOf](docs/Login200ResponseAnyOf.md)
 - [Login400Response](docs/Login400Response.md)
 - [Login400ResponseAnyOf](docs/Login400ResponseAnyOf.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [Moderator](docs/Moderator.md)
 - [ModeratorVendor](docs/ModeratorVendor.md)
 - [ModeratorVisibility](docs/ModeratorVisibility.md)
 - [NotFoundErrorResponse](docs/NotFoundErrorResponse.md)
 - [NumberFilterSchema](docs/NumberFilterSchema.md)
 - [OpenAiModelConfig](docs/OpenAiModelConfig.md)
 - [OptionKind](docs/OptionKind.md)
 - [Org](docs/Org.md)
 - [OrgData](docs/OrgData.md)
 - [PanelQualification](docs/PanelQualification.md)
 - [PanelRespondentAttribute](docs/PanelRespondentAttribute.md)
 - [PanelSettings](docs/PanelSettings.md)
 - [Participant](docs/Participant.md)
 - [ParticipantAttribute](docs/ParticipantAttribute.md)
 - [ParticipantCreate](docs/ParticipantCreate.md)
 - [ParticipantInvite](docs/ParticipantInvite.md)
 - [ParticipantInviteConfig](docs/ParticipantInviteConfig.md)
 - [ParticipantInviteData](docs/ParticipantInviteData.md)
 - [PhoneCallStartResponse](docs/PhoneCallStartResponse.md)
 - [Project](docs/Project.md)
 - [ProjectAnalysis](docs/ProjectAnalysis.md)
 - [ProjectAnalysisReport](docs/ProjectAnalysisReport.md)
 - [ProjectAudience](docs/ProjectAudience.md)
 - [ProjectBrief](docs/ProjectBrief.md)
 - [ProjectConfig](docs/ProjectConfig.md)
 - [ProjectConversationConfig](docs/ProjectConversationConfig.md)
 - [ProjectFile](docs/ProjectFile.md)
 - [ProjectFileCategory](docs/ProjectFileCategory.md)
 - [ProjectFileMetadata](docs/ProjectFileMetadata.md)
 - [ProjectFilePublic](docs/ProjectFilePublic.md)
 - [ProjectFilePublicFile](docs/ProjectFilePublicFile.md)
 - [ProjectKind](docs/ProjectKind.md)
 - [ProjectShareConfig](docs/ProjectShareConfig.md)
 - [ProjectStatus](docs/ProjectStatus.md)
 - [ProjectSummaryWithAnalytics](docs/ProjectSummaryWithAnalytics.md)
 - [ProjectWithAnalytics](docs/ProjectWithAnalytics.md)
 - [RemainingResponsesResponse](docs/RemainingResponsesResponse.md)
 - [RepdataQualification](docs/RepdataQualification.md)
 - [RepdataQualificationAllowedOptionIdsInner](docs/RepdataQualificationAllowedOptionIdsInner.md)
 - [RepdataRespondentAttribute](docs/RepdataRespondentAttribute.md)
 - [RepdataSurvey](docs/RepdataSurvey.md)
 - [RepdataSurveyAttributes](docs/RepdataSurveyAttributes.md)
 - [RepdataSurveyRedirects](docs/RepdataSurveyRedirects.md)
 - [Report](docs/Report.md)
 - [RequestShareAccess200Response](docs/RequestShareAccess200Response.md)
 - [RequestShareAccessRequest](docs/RequestShareAccessRequest.md)
 - [ResetPasswordRequest](docs/ResetPasswordRequest.md)
 - [ResponseCallCompletedEvent](docs/ResponseCallCompletedEvent.md)
 - [ResponseCallFailedEvent](docs/ResponseCallFailedEvent.md)
 - [ResponseConsentEvent](docs/ResponseConsentEvent.md)
 - [ResponseOptOutEvent](docs/ResponseOptOutEvent.md)
 - [ResponseProcessingCompletedEvent](docs/ResponseProcessingCompletedEvent.md)
 - [ResponseProcessingFailedEvent](docs/ResponseProcessingFailedEvent.md)
 - [ResponseRedirectEvent](docs/ResponseRedirectEvent.md)
 - [ResponseStartCallEvent](docs/ResponseStartCallEvent.md)
 - [ResponseSubmitEmailEvent](docs/ResponseSubmitEmailEvent.md)
 - [ResponseSubmitScreenerEvent](docs/ResponseSubmitScreenerEvent.md)
 - [ScreenerQuestion](docs/ScreenerQuestion.md)
 - [ScreenerQuestionChooseMultiple](docs/ScreenerQuestionChooseMultiple.md)
 - [ScreenerQuestionChooseMultipleOptionsValue](docs/ScreenerQuestionChooseMultipleOptionsValue.md)
 - [ScreenerQuestionChooseMultiplePublic](docs/ScreenerQuestionChooseMultiplePublic.md)
 - [ScreenerQuestionChooseOne](docs/ScreenerQuestionChooseOne.md)
 - [ScreenerQuestionChooseOnePublic](docs/ScreenerQuestionChooseOnePublic.md)
 - [ScreenerQuestionOption](docs/ScreenerQuestionOption.md)
 - [ScreenerQuestionPublic](docs/ScreenerQuestionPublic.md)
 - [ScreenerQuestionResponse](docs/ScreenerQuestionResponse.md)
 - [SearchProjectTranscriptsResponse](docs/SearchProjectTranscriptsResponse.md)
 - [SearchSharedResponseMessages200ResponseInner](docs/SearchSharedResponseMessages200ResponseInner.md)
 - [SearchSharedResponseMessagesRequest](docs/SearchSharedResponseMessagesRequest.md)
 - [SearchSharedResponseMessagesRequestInviteResponseMessagesInner](docs/SearchSharedResponseMessagesRequestInviteResponseMessagesInner.md)
 - [SelectFilterSchema](docs/SelectFilterSchema.md)
 - [ShareEntity](docs/ShareEntity.md)
 - [ShareEntityConfig](docs/ShareEntityConfig.md)
 - [ShareEntityCreatedByKind](docs/ShareEntityCreatedByKind.md)
 - [ShareEntityKind](docs/ShareEntityKind.md)
 - [SignupRequest](docs/SignupRequest.md)
 - [StartPhoneCallForCodeInviteResponseRequest](docs/StartPhoneCallForCodeInviteResponseRequest.md)
 - [ThematicAnalysisArtifactCreateData](docs/ThematicAnalysisArtifactCreateData.md)
 - [ThematicAnalysisArtifactCreateDataThemesInner](docs/ThematicAnalysisArtifactCreateDataThemesInner.md)
 - [ThematicAnalysisArtifactCreateDataThemesInnerCodesInner](docs/ThematicAnalysisArtifactCreateDataThemesInnerCodesInner.md)
 - [ThematicAnalysisResponseCode](docs/ThematicAnalysisResponseCode.md)
 - [ThematicAnalysisResponseCodeCodesInner](docs/ThematicAnalysisResponseCodeCodesInner.md)
 - [ThematicAnalysisResponseCodeCodesInnerEvidence](docs/ThematicAnalysisResponseCodeCodesInnerEvidence.md)
 - [Thread](docs/Thread.md)
 - [ThreadCreateProjectStatus](docs/ThreadCreateProjectStatus.md)
 - [ThreadFile](docs/ThreadFile.md)
 - [ThreadKind](docs/ThreadKind.md)
 - [ThreadMetadata](docs/ThreadMetadata.md)
 - [TokenKind](docs/TokenKind.md)
 - [Transcript](docs/Transcript.md)
 - [TranscriptAttributesInner](docs/TranscriptAttributesInner.md)
 - [TranscriptMessage](docs/TranscriptMessage.md)
 - [TranscriptMessagesInner](docs/TranscriptMessagesInner.md)
 - [TranscriptQuality](docs/TranscriptQuality.md)
 - [TranscriptResponseAttribute](docs/TranscriptResponseAttribute.md)
 - [UnauthorizedErrorResponse](docs/UnauthorizedErrorResponse.md)
 - [UpdateArtifactRequest](docs/UpdateArtifactRequest.md)
 - [UpdateCallForCodeInviteResponseRequest](docs/UpdateCallForCodeInviteResponseRequest.md)
 - [UpdateCallForCodeInviteResponseRequestCall](docs/UpdateCallForCodeInviteResponseRequestCall.md)
 - [UpdateCodeInviteResponse404Response](docs/UpdateCodeInviteResponse404Response.md)
 - [UpdateShareEntityRequest](docs/UpdateShareEntityRequest.md)
 - [UpdateWorkspaceMemberRequest](docs/UpdateWorkspaceMemberRequest.md)
 - [User](docs/User.md)
 - [UserAccountStatus](docs/UserAccountStatus.md)
 - [UserAdminLevel](docs/UserAdminLevel.md)
 - [UserData](docs/UserData.md)
 - [UserProvider](docs/UserProvider.md)
 - [UserWithConfig](docs/UserWithConfig.md)
 - [VapiAssistantConfig](docs/VapiAssistantConfig.md)
 - [VapiVoiceId](docs/VapiVoiceId.md)
 - [VapiVoiceVapiProvider](docs/VapiVoiceVapiProvider.md)
 - [VerifyEmailAccessForShare200Response](docs/VerifyEmailAccessForShare200Response.md)
 - [VerifyEmailAccessForShareRequest](docs/VerifyEmailAccessForShareRequest.md)
 - [VerifyEmailRequest](docs/VerifyEmailRequest.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceListItem](docs/WorkspaceListItem.md)
 - [WorkspaceMember](docs/WorkspaceMember.md)
 - [WorkspaceMemberItem](docs/WorkspaceMemberItem.md)
 - [WorkspaceMemberResponse](docs/WorkspaceMemberResponse.md)
 - [WorkspaceMemberRole](docs/WorkspaceMemberRole.md)
 - [WorkspaceMemberUser](docs/WorkspaceMemberUser.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (JWT)


## Author




