# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.api_projects_post_request_thread_assets_inner import ApiProjectsPostRequestThreadAssetsInner
from keplar_api.models.project_config import ProjectConfig
from keplar_api.models.project_conversation_config import ProjectConversationConfig
from keplar_api.models.project_status import ProjectStatus
from typing import Optional, Set
from typing_extensions import Self

class ApiProjectsPostRequest(BaseModel):
    """
    ApiProjectsPostRequest
    """ # noqa: E501
    name: StrictStr
    description: Optional[StrictStr] = None
    status: Optional[ProjectStatus] = None
    config: ProjectConfig
    conversation_config: ProjectConversationConfig = Field(alias="conversationConfig")
    thread_assets: Optional[List[ApiProjectsPostRequestThreadAssetsInner]] = Field(default=None, alias="threadAssets")
    thread_id: Optional[StrictStr] = Field(default=None, alias="threadId")
    __properties: ClassVar[List[str]] = ["name", "description", "status", "config", "conversationConfig", "threadAssets", "threadId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ApiProjectsPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversation_config
        if self.conversation_config:
            _dict['conversationConfig'] = self.conversation_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in thread_assets (list)
        _items = []
        if self.thread_assets:
            for _item_thread_assets in self.thread_assets:
                if _item_thread_assets:
                    _items.append(_item_thread_assets.to_dict())
            _dict['threadAssets'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ApiProjectsPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "config": ProjectConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "conversationConfig": ProjectConversationConfig.from_dict(obj["conversationConfig"]) if obj.get("conversationConfig") is not None else None,
            "threadAssets": [ApiProjectsPostRequestThreadAssetsInner.from_dict(_item) for _item in obj["threadAssets"]] if obj.get("threadAssets") is not None else None,
            "threadId": obj.get("threadId")
        })
        return _obj


