# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.artifact_data import ArtifactData
from keplar_api.models.artifact_kind import ArtifactKind
from keplar_api.models.artifact_metadata import ArtifactMetadata
from typing import Optional, Set
from typing_extensions import Self

class Artifact(BaseModel):
    """
    Artifact
    """ # noqa: E501
    id: StrictStr
    title: Optional[StrictStr] = None
    kind: ArtifactKind
    project_id: StrictStr = Field(alias="projectId")
    attribute_kind_group_id: Optional[StrictStr] = Field(default=None, alias="attributeKindGroupId")
    version_group_id: StrictStr = Field(alias="versionGroupId")
    data: Optional[ArtifactData] = None
    metadata: ArtifactMetadata
    created_by_id: StrictStr = Field(alias="createdById")
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    project: Optional[Project] = None
    attribute_kind_group: Optional[AttributeKindGroup] = Field(default=None, alias="attributeKindGroup")
    version_group: Optional[ArtifactVersionGroup] = Field(default=None, alias="versionGroup")
    latest_for_group: Optional[ArtifactVersionGroup] = Field(default=None, alias="latestForGroup")
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    __properties: ClassVar[List[str]] = ["id", "title", "kind", "projectId", "attributeKindGroupId", "versionGroupId", "data", "metadata", "createdById", "createdAt", "updatedAt", "project", "attributeKindGroup", "versionGroup", "latestForGroup", "createdBy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Artifact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attribute_kind_group
        if self.attribute_kind_group:
            _dict['attributeKindGroup'] = self.attribute_kind_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of version_group
        if self.version_group:
            _dict['versionGroup'] = self.version_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latest_for_group
        if self.latest_for_group:
            _dict['latestForGroup'] = self.latest_for_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if attribute_kind_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.attribute_kind_group_id is None and "attribute_kind_group_id" in self.model_fields_set:
            _dict['attributeKindGroupId'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if attribute_kind_group (nullable) is None
        # and model_fields_set contains the field
        if self.attribute_kind_group is None and "attribute_kind_group" in self.model_fields_set:
            _dict['attributeKindGroup'] = None

        # set to None if latest_for_group (nullable) is None
        # and model_fields_set contains the field
        if self.latest_for_group is None and "latest_for_group" in self.model_fields_set:
            _dict['latestForGroup'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Artifact from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "title": obj.get("title"),
            "kind": obj.get("kind"),
            "projectId": obj.get("projectId"),
            "attributeKindGroupId": obj.get("attributeKindGroupId"),
            "versionGroupId": obj.get("versionGroupId"),
            "data": ArtifactData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "metadata": ArtifactMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "createdById": obj.get("createdById"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "attributeKindGroup": AttributeKindGroup.from_dict(obj["attributeKindGroup"]) if obj.get("attributeKindGroup") is not None else None,
            "versionGroup": ArtifactVersionGroup.from_dict(obj["versionGroup"]) if obj.get("versionGroup") is not None else None,
            "latestForGroup": ArtifactVersionGroup.from_dict(obj["latestForGroup"]) if obj.get("latestForGroup") is not None else None,
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None
        })
        return _obj

from keplar_api.models.artifact_version_group import ArtifactVersionGroup
from keplar_api.models.attribute_kind_group import AttributeKindGroup
from keplar_api.models.project import Project
from keplar_api.models.user import User
# TODO: Rewrite to not use raise_errors
Artifact.model_rebuild(raise_errors=False)

