# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.artifact_kind import ArtifactKind
from typing import Optional, Set
from typing_extensions import Self

class ArtifactVersionGroup(BaseModel):
    """
    ArtifactVersionGroup
    """ # noqa: E501
    id: StrictStr
    project_id: StrictStr = Field(alias="projectId")
    kind: ArtifactKind
    latest_artifact_id: Optional[StrictStr] = Field(default=None, alias="latestArtifactId")
    project: Optional[Project] = None
    latest_artifact: Optional[Artifact] = Field(default=None, alias="latestArtifact")
    artifacts: Optional[List[Artifact]] = None
    __properties: ClassVar[List[str]] = ["id", "projectId", "kind", "latestArtifactId", "project", "latestArtifact", "artifacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArtifactVersionGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of latest_artifact
        if self.latest_artifact:
            _dict['latestArtifact'] = self.latest_artifact.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in artifacts (list)
        _items = []
        if self.artifacts:
            for _item_artifacts in self.artifacts:
                if _item_artifacts:
                    _items.append(_item_artifacts.to_dict())
            _dict['artifacts'] = _items
        # set to None if latest_artifact_id (nullable) is None
        # and model_fields_set contains the field
        if self.latest_artifact_id is None and "latest_artifact_id" in self.model_fields_set:
            _dict['latestArtifactId'] = None

        # set to None if latest_artifact (nullable) is None
        # and model_fields_set contains the field
        if self.latest_artifact is None and "latest_artifact" in self.model_fields_set:
            _dict['latestArtifact'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArtifactVersionGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "projectId": obj.get("projectId"),
            "kind": obj.get("kind"),
            "latestArtifactId": obj.get("latestArtifactId"),
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "latestArtifact": Artifact.from_dict(obj["latestArtifact"]) if obj.get("latestArtifact") is not None else None,
            "artifacts": [Artifact.from_dict(_item) for _item in obj["artifacts"]] if obj.get("artifacts") is not None else None
        })
        return _obj

from keplar_api.models.artifact import Artifact
from keplar_api.models.project import Project
# TODO: Rewrite to not use raise_errors
ArtifactVersionGroup.model_rebuild(raise_errors=False)

