# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Attribute(BaseModel):
    """
    Attribute
    """ # noqa: E501
    id: StrictStr
    attribute_kind_id: StrictStr = Field(alias="attributeKindId")
    value: StrictStr
    description: Optional[StrictStr] = None
    created_at: datetime = Field(alias="createdAt")
    attribute_kind: Optional[AttributeKind] = Field(default=None, alias="attributeKind")
    participant_attributes: Optional[List[ParticipantAttribute]] = Field(default=None, alias="participantAttributes")
    invite_response_attributes: Optional[List[InviteResponseAttribute]] = Field(default=None, alias="inviteResponseAttributes")
    __properties: ClassVar[List[str]] = ["id", "attributeKindId", "value", "description", "createdAt", "attributeKind", "participantAttributes", "inviteResponseAttributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Attribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of attribute_kind
        if self.attribute_kind:
            _dict['attributeKind'] = self.attribute_kind.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in participant_attributes (list)
        _items = []
        if self.participant_attributes:
            for _item_participant_attributes in self.participant_attributes:
                if _item_participant_attributes:
                    _items.append(_item_participant_attributes.to_dict())
            _dict['participantAttributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invite_response_attributes (list)
        _items = []
        if self.invite_response_attributes:
            for _item_invite_response_attributes in self.invite_response_attributes:
                if _item_invite_response_attributes:
                    _items.append(_item_invite_response_attributes.to_dict())
            _dict['inviteResponseAttributes'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Attribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "attributeKindId": obj.get("attributeKindId"),
            "value": obj.get("value"),
            "description": obj.get("description"),
            "createdAt": obj.get("createdAt"),
            "attributeKind": AttributeKind.from_dict(obj["attributeKind"]) if obj.get("attributeKind") is not None else None,
            "participantAttributes": [ParticipantAttribute.from_dict(_item) for _item in obj["participantAttributes"]] if obj.get("participantAttributes") is not None else None,
            "inviteResponseAttributes": [InviteResponseAttribute.from_dict(_item) for _item in obj["inviteResponseAttributes"]] if obj.get("inviteResponseAttributes") is not None else None
        })
        return _obj

from keplar_api.models.attribute_kind import AttributeKind
from keplar_api.models.invite_response_attribute import InviteResponseAttribute
from keplar_api.models.participant_attribute import ParticipantAttribute
# TODO: Rewrite to not use raise_errors
Attribute.model_rebuild(raise_errors=False)

