# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.attribute_value_kind import AttributeValueKind
from typing import Optional, Set
from typing_extensions import Self

class AttributeKind(BaseModel):
    """
    AttributeKind
    """ # noqa: E501
    id: StrictStr
    key: Optional[StrictStr] = None
    label: StrictStr
    value_kind: AttributeValueKind = Field(alias="valueKind")
    description: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    attribute_kind_group_id: Optional[StrictStr] = Field(default=None, alias="attributeKindGroupId")
    attributes: Optional[List[Attribute]] = None
    attribute_kind_group: Optional[AttributeKindGroup] = Field(default=None, alias="attributeKindGroup")
    __properties: ClassVar[List[str]] = ["id", "key", "label", "valueKind", "description", "category", "createdAt", "updatedAt", "attributeKindGroupId", "attributes", "attributeKindGroup"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttributeKind from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item_attributes in self.attributes:
                if _item_attributes:
                    _items.append(_item_attributes.to_dict())
            _dict['attributes'] = _items
        # override the default output from pydantic by calling `to_dict()` of attribute_kind_group
        if self.attribute_kind_group:
            _dict['attributeKindGroup'] = self.attribute_kind_group.to_dict()
        # set to None if key (nullable) is None
        # and model_fields_set contains the field
        if self.key is None and "key" in self.model_fields_set:
            _dict['key'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if attribute_kind_group_id (nullable) is None
        # and model_fields_set contains the field
        if self.attribute_kind_group_id is None and "attribute_kind_group_id" in self.model_fields_set:
            _dict['attributeKindGroupId'] = None

        # set to None if attribute_kind_group (nullable) is None
        # and model_fields_set contains the field
        if self.attribute_kind_group is None and "attribute_kind_group" in self.model_fields_set:
            _dict['attributeKindGroup'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttributeKind from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "key": obj.get("key"),
            "label": obj.get("label"),
            "valueKind": obj.get("valueKind"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "attributeKindGroupId": obj.get("attributeKindGroupId"),
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None,
            "attributeKindGroup": AttributeKindGroup.from_dict(obj["attributeKindGroup"]) if obj.get("attributeKindGroup") is not None else None
        })
        return _obj

from keplar_api.models.attribute import Attribute
from keplar_api.models.attribute_kind_group import AttributeKindGroup
# TODO: Rewrite to not use raise_errors
AttributeKind.model_rebuild(raise_errors=False)

