# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.attribute_kind_group_purpose import AttributeKindGroupPurpose
from keplar_api.models.attribute_kind_group_scope import AttributeKindGroupScope
from typing import Optional, Set
from typing_extensions import Self

class AttributeKindGroup(BaseModel):
    """
    AttributeKindGroup
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    description: Optional[StrictStr] = None
    scope: AttributeKindGroupScope
    purpose: AttributeKindGroupPurpose
    workspace_id: StrictStr = Field(alias="workspaceId")
    project_id: StrictStr = Field(alias="projectId")
    created_by_id: StrictStr = Field(alias="createdById")
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    workspace: Optional[Workspace] = None
    project: Optional[Project] = None
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    attribute_kinds: Optional[List[AttributeKind]] = Field(default=None, alias="attributeKinds")
    artifacts: Optional[List[Artifact]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "scope", "purpose", "workspaceId", "projectId", "createdById", "createdAt", "updatedAt", "workspace", "project", "createdBy", "attributeKinds", "artifacts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AttributeKindGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attribute_kinds (list)
        _items = []
        if self.attribute_kinds:
            for _item_attribute_kinds in self.attribute_kinds:
                if _item_attribute_kinds:
                    _items.append(_item_attribute_kinds.to_dict())
            _dict['attributeKinds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in artifacts (list)
        _items = []
        if self.artifacts:
            for _item_artifacts in self.artifacts:
                if _item_artifacts:
                    _items.append(_item_artifacts.to_dict())
            _dict['artifacts'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AttributeKindGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "scope": obj.get("scope"),
            "purpose": obj.get("purpose"),
            "workspaceId": obj.get("workspaceId"),
            "projectId": obj.get("projectId"),
            "createdById": obj.get("createdById"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "attributeKinds": [AttributeKind.from_dict(_item) for _item in obj["attributeKinds"]] if obj.get("attributeKinds") is not None else None,
            "artifacts": [Artifact.from_dict(_item) for _item in obj["artifacts"]] if obj.get("artifacts") is not None else None
        })
        return _obj

from keplar_api.models.artifact import Artifact
from keplar_api.models.attribute_kind import AttributeKind
from keplar_api.models.project import Project
from keplar_api.models.user import User
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
AttributeKindGroup.model_rebuild(raise_errors=False)

