# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from keplar_api.models.repdata_qualification import RepdataQualification
from typing import Optional, Set
from typing_extensions import Self

class ByoPanelRepdataConfig(BaseModel):
    """
    ByoPanelRepdataConfig
    """ # noqa: E501
    kind: StrictStr
    selected_qualifications: List[RepdataQualification] = Field(alias="selectedQualifications")
    __properties: ClassVar[List[str]] = ["kind", "selectedQualifications"]

    @field_validator('kind')
    def kind_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['REPDATA']):
            raise ValueError("must be one of enum values ('REPDATA')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ByoPanelRepdataConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in selected_qualifications (list)
        _items = []
        if self.selected_qualifications:
            for _item_selected_qualifications in self.selected_qualifications:
                if _item_selected_qualifications:
                    _items.append(_item_selected_qualifications.to_dict())
            _dict['selectedQualifications'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ByoPanelRepdataConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "kind": obj.get("kind"),
            "selectedQualifications": [RepdataQualification.from_dict(_item) for _item in obj["selectedQualifications"]] if obj.get("selectedQualifications") is not None else None
        })
        return _obj


