# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.call_kind import CallKind
from keplar_api.models.call_metadata import CallMetadata
from keplar_api.models.call_status import CallStatus
from typing import Optional, Set
from typing_extensions import Self

class Call(BaseModel):
    """
    Call
    """ # noqa: E501
    id: StrictStr
    vendor: StrictStr
    vendor_call_id: Optional[StrictStr] = Field(default=None, alias="vendorCallId")
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    started_at: Optional[datetime] = Field(default=None, alias="startedAt")
    ended_at: Optional[datetime] = Field(default=None, alias="endedAt")
    kind: Optional[CallKind] = None
    status: Optional[CallStatus] = None
    phone_number: Optional[StrictStr] = Field(default=None, alias="phoneNumber")
    metadata: Optional[CallMetadata] = None
    invite_response_id: StrictStr = Field(alias="inviteResponseId")
    participant_id: Optional[StrictStr] = Field(default=None, alias="participantId")
    invite_id: Optional[StrictStr] = Field(default=None, alias="inviteId")
    analysis: Optional[Any] = None
    invite_response: Optional[InviteResponse] = Field(default=None, alias="inviteResponse")
    events: Optional[List[CallEvent]] = None
    participant: Optional[Participant] = None
    invite: Optional[Invite] = None
    conversation_messages: Optional[List[ConversationMessage]] = Field(default=None, alias="conversationMessages")
    conversation_message_topics: Optional[List[ConversationMessageTopic]] = Field(default=None, alias="conversationMessageTopics")
    __properties: ClassVar[List[str]] = ["id", "vendor", "vendorCallId", "createdAt", "updatedAt", "startedAt", "endedAt", "kind", "status", "phoneNumber", "metadata", "inviteResponseId", "participantId", "inviteId", "analysis", "inviteResponse", "events", "participant", "invite", "conversationMessages", "conversationMessageTopics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Call from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invite_response
        if self.invite_response:
            _dict['inviteResponse'] = self.invite_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in events (list)
        _items = []
        if self.events:
            for _item_events in self.events:
                if _item_events:
                    _items.append(_item_events.to_dict())
            _dict['events'] = _items
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invite
        if self.invite:
            _dict['invite'] = self.invite.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in conversation_messages (list)
        _items = []
        if self.conversation_messages:
            for _item_conversation_messages in self.conversation_messages:
                if _item_conversation_messages:
                    _items.append(_item_conversation_messages.to_dict())
            _dict['conversationMessages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in conversation_message_topics (list)
        _items = []
        if self.conversation_message_topics:
            for _item_conversation_message_topics in self.conversation_message_topics:
                if _item_conversation_message_topics:
                    _items.append(_item_conversation_message_topics.to_dict())
            _dict['conversationMessageTopics'] = _items
        # set to None if vendor_call_id (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_call_id is None and "vendor_call_id" in self.model_fields_set:
            _dict['vendorCallId'] = None

        # set to None if started_at (nullable) is None
        # and model_fields_set contains the field
        if self.started_at is None and "started_at" in self.model_fields_set:
            _dict['startedAt'] = None

        # set to None if ended_at (nullable) is None
        # and model_fields_set contains the field
        if self.ended_at is None and "ended_at" in self.model_fields_set:
            _dict['endedAt'] = None

        # set to None if kind (nullable) is None
        # and model_fields_set contains the field
        if self.kind is None and "kind" in self.model_fields_set:
            _dict['kind'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if phone_number (nullable) is None
        # and model_fields_set contains the field
        if self.phone_number is None and "phone_number" in self.model_fields_set:
            _dict['phoneNumber'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if participant_id (nullable) is None
        # and model_fields_set contains the field
        if self.participant_id is None and "participant_id" in self.model_fields_set:
            _dict['participantId'] = None

        # set to None if invite_id (nullable) is None
        # and model_fields_set contains the field
        if self.invite_id is None and "invite_id" in self.model_fields_set:
            _dict['inviteId'] = None

        # set to None if analysis (nullable) is None
        # and model_fields_set contains the field
        if self.analysis is None and "analysis" in self.model_fields_set:
            _dict['analysis'] = None

        # set to None if participant (nullable) is None
        # and model_fields_set contains the field
        if self.participant is None and "participant" in self.model_fields_set:
            _dict['participant'] = None

        # set to None if invite (nullable) is None
        # and model_fields_set contains the field
        if self.invite is None and "invite" in self.model_fields_set:
            _dict['invite'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Call from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "vendor": obj.get("vendor"),
            "vendorCallId": obj.get("vendorCallId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "startedAt": obj.get("startedAt"),
            "endedAt": obj.get("endedAt"),
            "kind": obj.get("kind"),
            "status": obj.get("status"),
            "phoneNumber": obj.get("phoneNumber"),
            "metadata": CallMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "inviteResponseId": obj.get("inviteResponseId"),
            "participantId": obj.get("participantId"),
            "inviteId": obj.get("inviteId"),
            "analysis": obj.get("analysis"),
            "inviteResponse": InviteResponse.from_dict(obj["inviteResponse"]) if obj.get("inviteResponse") is not None else None,
            "events": [CallEvent.from_dict(_item) for _item in obj["events"]] if obj.get("events") is not None else None,
            "participant": Participant.from_dict(obj["participant"]) if obj.get("participant") is not None else None,
            "invite": Invite.from_dict(obj["invite"]) if obj.get("invite") is not None else None,
            "conversationMessages": [ConversationMessage.from_dict(_item) for _item in obj["conversationMessages"]] if obj.get("conversationMessages") is not None else None,
            "conversationMessageTopics": [ConversationMessageTopic.from_dict(_item) for _item in obj["conversationMessageTopics"]] if obj.get("conversationMessageTopics") is not None else None
        })
        return _obj

from keplar_api.models.call_event import CallEvent
from keplar_api.models.conversation_message import ConversationMessage
from keplar_api.models.conversation_message_topic import ConversationMessageTopic
from keplar_api.models.invite import Invite
from keplar_api.models.invite_response import InviteResponse
from keplar_api.models.participant import Participant
# TODO: Rewrite to not use raise_errors
Call.model_rebuild(raise_errors=False)

