# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.call_analysis import CallAnalysis
from typing import Optional, Set
from typing_extensions import Self

class CallMetadata(BaseModel):
    """
    CallMetadata
    """ # noqa: E501
    recording_url: Optional[StrictStr] = Field(default=None, alias="recordingUrl")
    transcript: Optional[StrictStr] = None
    transcript_quality: Optional[StrictStr] = Field(default=None, alias="transcriptQuality")
    transcript_markdown: Optional[StrictStr] = Field(default=None, alias="transcriptMarkdown")
    transcript_insight: Optional[StrictStr] = Field(default=None, alias="transcriptInsight")
    analysis: Optional[CallAnalysis] = None
    gcs_url: Optional[StrictStr] = Field(default=None, alias="gcsUrl")
    gcs_path: Optional[StrictStr] = Field(default=None, alias="gcsPath")
    gcs_uploaded_at: Optional[StrictStr] = Field(default=None, alias="gcsUploadedAt")
    gcs_last_synced_at: Optional[StrictStr] = Field(default=None, alias="gcsLastSyncedAt")
    __properties: ClassVar[List[str]] = ["recordingUrl", "transcript", "transcriptQuality", "transcriptMarkdown", "transcriptInsight", "analysis", "gcsUrl", "gcsPath", "gcsUploadedAt", "gcsLastSyncedAt"]

    @field_validator('transcript_quality')
    def transcript_quality_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HIGH', 'MEDIUM', 'LOW']):
            raise ValueError("must be one of enum values ('HIGH', 'MEDIUM', 'LOW')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of analysis
        if self.analysis:
            _dict['analysis'] = self.analysis.to_dict()
        # set to None if analysis (nullable) is None
        # and model_fields_set contains the field
        if self.analysis is None and "analysis" in self.model_fields_set:
            _dict['analysis'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "recordingUrl": obj.get("recordingUrl"),
            "transcript": obj.get("transcript"),
            "transcriptQuality": obj.get("transcriptQuality"),
            "transcriptMarkdown": obj.get("transcriptMarkdown"),
            "transcriptInsight": obj.get("transcriptInsight"),
            "analysis": CallAnalysis.from_dict(obj["analysis"]) if obj.get("analysis") is not None else None,
            "gcsUrl": obj.get("gcsUrl"),
            "gcsPath": obj.get("gcsPath"),
            "gcsUploadedAt": obj.get("gcsUploadedAt"),
            "gcsLastSyncedAt": obj.get("gcsLastSyncedAt")
        })
        return _obj


