# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ChatSession(BaseModel):
    """
    ChatSession
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    description: Optional[StrictStr] = None
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    kind: Optional[StrictStr] = None
    data: Optional[Any] = None
    created_by_id: StrictStr = Field(alias="createdById")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    project: Optional[Project] = None
    chat_messages: Optional[List[ChatMessage]] = Field(default=None, alias="chatMessages")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "createdAt", "updatedAt", "kind", "data", "createdById", "projectId", "createdBy", "project", "chatMessages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatSession from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in chat_messages (list)
        _items = []
        if self.chat_messages:
            for _item_chat_messages in self.chat_messages:
                if _item_chat_messages:
                    _items.append(_item_chat_messages.to_dict())
            _dict['chatMessages'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if kind (nullable) is None
        # and model_fields_set contains the field
        if self.kind is None and "kind" in self.model_fields_set:
            _dict['kind'] = None

        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict['projectId'] = None

        # set to None if project (nullable) is None
        # and model_fields_set contains the field
        if self.project is None and "project" in self.model_fields_set:
            _dict['project'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatSession from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "kind": obj.get("kind"),
            "data": obj.get("data"),
            "createdById": obj.get("createdById"),
            "projectId": obj.get("projectId"),
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "chatMessages": [ChatMessage.from_dict(_item) for _item in obj["chatMessages"]] if obj.get("chatMessages") is not None else None
        })
        return _obj

from keplar_api.models.chat_message import ChatMessage
from keplar_api.models.project import Project
from keplar_api.models.user import User
# TODO: Rewrite to not use raise_errors
ChatSession.model_rebuild(raise_errors=False)

