# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.invite_response_data import InviteResponseData
from keplar_api.models.invite_response_kind import InviteResponseKind
from keplar_api.models.invite_response_status import InviteResponseStatus
from keplar_api.models.participant import Participant
from typing import Optional, Set
from typing_extensions import Self

class CodeInviteResponse(BaseModel):
    """
    CodeInviteResponse
    """ # noqa: E501
    id: StrictStr
    invite_id: StrictStr = Field(alias="inviteId")
    kind: InviteResponseKind
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    data: Optional[InviteResponseData] = None
    status: InviteResponseStatus
    participant_id: Optional[StrictStr] = Field(default=None, alias="participantId")
    participant: Optional[Participant] = None
    __properties: ClassVar[List[str]] = ["id", "inviteId", "kind", "createdAt", "updatedAt", "data", "status", "participantId", "participant"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodeInviteResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if participant_id (nullable) is None
        # and model_fields_set contains the field
        if self.participant_id is None and "participant_id" in self.model_fields_set:
            _dict['participantId'] = None

        # set to None if participant (nullable) is None
        # and model_fields_set contains the field
        if self.participant is None and "participant" in self.model_fields_set:
            _dict['participant'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodeInviteResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "inviteId": obj.get("inviteId"),
            "kind": obj.get("kind"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "data": InviteResponseData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "status": obj.get("status"),
            "participantId": obj.get("participantId"),
            "participant": Participant.from_dict(obj["participant"]) if obj.get("participant") is not None else None
        })
        return _obj


