# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ConversationMessage(BaseModel):
    """
    ConversationMessage
    """ # noqa: E501
    call_id: StrictStr = Field(alias="callId")
    index: Union[StrictFloat, StrictInt]
    role: StrictStr
    source: Optional[StrictStr] = None
    time: datetime
    end_time: datetime = Field(alias="endTime")
    message: StrictStr
    duration: Union[StrictFloat, StrictInt]
    seconds_from_start: Union[StrictFloat, StrictInt] = Field(alias="secondsFromStart")
    conversation_message_topic_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="conversationMessageTopicIndex")
    call: Optional[Call] = None
    conversation_message_topic: Optional[ConversationMessageTopic] = Field(default=None, alias="conversationMessageTopic")
    __properties: ClassVar[List[str]] = ["callId", "index", "role", "source", "time", "endTime", "message", "duration", "secondsFromStart", "conversationMessageTopicIndex", "call", "conversationMessageTopic"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConversationMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of call
        if self.call:
            _dict['call'] = self.call.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversation_message_topic
        if self.conversation_message_topic:
            _dict['conversationMessageTopic'] = self.conversation_message_topic.to_dict()
        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if conversation_message_topic_index (nullable) is None
        # and model_fields_set contains the field
        if self.conversation_message_topic_index is None and "conversation_message_topic_index" in self.model_fields_set:
            _dict['conversationMessageTopicIndex'] = None

        # set to None if conversation_message_topic (nullable) is None
        # and model_fields_set contains the field
        if self.conversation_message_topic is None and "conversation_message_topic" in self.model_fields_set:
            _dict['conversationMessageTopic'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConversationMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callId": obj.get("callId"),
            "index": obj.get("index"),
            "role": obj.get("role"),
            "source": obj.get("source"),
            "time": obj.get("time"),
            "endTime": obj.get("endTime"),
            "message": obj.get("message"),
            "duration": obj.get("duration"),
            "secondsFromStart": obj.get("secondsFromStart"),
            "conversationMessageTopicIndex": obj.get("conversationMessageTopicIndex"),
            "call": Call.from_dict(obj["call"]) if obj.get("call") is not None else None,
            "conversationMessageTopic": ConversationMessageTopic.from_dict(obj["conversationMessageTopic"]) if obj.get("conversationMessageTopic") is not None else None
        })
        return _obj

from keplar_api.models.call import Call
from keplar_api.models.conversation_message_topic import ConversationMessageTopic
# TODO: Rewrite to not use raise_errors
ConversationMessage.model_rebuild(raise_errors=False)

