# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class EmailShare(BaseModel):
    """
    EmailShare
    """ # noqa: E501
    id: StrictStr
    email: StrictStr
    share_entity_id: StrictStr = Field(alias="shareEntityId")
    access_token: StrictStr = Field(alias="accessToken")
    created_at: datetime = Field(alias="createdAt")
    expires_at: datetime = Field(alias="expiresAt")
    accessed_at: Optional[datetime] = Field(default=None, alias="accessedAt")
    share_entity: Optional[ShareEntity] = Field(default=None, alias="shareEntity")
    __properties: ClassVar[List[str]] = ["id", "email", "shareEntityId", "accessToken", "createdAt", "expiresAt", "accessedAt", "shareEntity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailShare from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of share_entity
        if self.share_entity:
            _dict['shareEntity'] = self.share_entity.to_dict()
        # set to None if accessed_at (nullable) is None
        # and model_fields_set contains the field
        if self.accessed_at is None and "accessed_at" in self.model_fields_set:
            _dict['accessedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailShare from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "shareEntityId": obj.get("shareEntityId"),
            "accessToken": obj.get("accessToken"),
            "createdAt": obj.get("createdAt"),
            "expiresAt": obj.get("expiresAt"),
            "accessedAt": obj.get("accessedAt"),
            "shareEntity": ShareEntity.from_dict(obj["shareEntity"]) if obj.get("shareEntity") is not None else None
        })
        return _obj

from keplar_api.models.share_entity import ShareEntity
# TODO: Rewrite to not use raise_errors
EmailShare.model_rebuild(raise_errors=False)

