# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.file_mime_type import FileMimeType
from typing import Optional, Set
from typing_extensions import Self

class File(BaseModel):
    """
    File
    """ # noqa: E501
    id: StrictStr
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    filename: StrictStr
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    mime_type: FileMimeType = Field(alias="mimeType")
    size: StrictStr
    bucket_name: StrictStr = Field(alias="bucketName")
    gcs_path: StrictStr = Field(alias="gcsPath")
    gcs_generation: Optional[StrictStr] = Field(default=None, alias="gcsGeneration")
    uploaded_by_id: StrictStr = Field(alias="uploadedById")
    workspace_id: StrictStr = Field(alias="workspaceId")
    description: Optional[StrictStr] = None
    metadata: Optional[Dict[str, Any]] = None
    is_public: StrictBool = Field(alias="isPublic")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    public_url: Optional[StrictStr] = Field(default=None, alias="publicUrl")
    public_url_expires_at: Optional[datetime] = Field(default=None, alias="publicUrlExpiresAt")
    uploaded_by: Optional[User] = Field(default=None, alias="uploadedBy")
    workspace: Optional[Workspace] = None
    project_files: Optional[List[ProjectFile]] = Field(default=None, alias="projectFiles")
    thread_files: Optional[List[ThreadFile]] = Field(default=None, alias="threadFiles")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "updatedAt", "filename", "displayName", "mimeType", "size", "bucketName", "gcsPath", "gcsGeneration", "uploadedById", "workspaceId", "description", "metadata", "isPublic", "expiresAt", "publicUrl", "publicUrlExpiresAt", "uploadedBy", "workspace", "projectFiles", "threadFiles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of File from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of uploaded_by
        if self.uploaded_by:
            _dict['uploadedBy'] = self.uploaded_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workspace
        if self.workspace:
            _dict['workspace'] = self.workspace.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in project_files (list)
        _items = []
        if self.project_files:
            for _item_project_files in self.project_files:
                if _item_project_files:
                    _items.append(_item_project_files.to_dict())
            _dict['projectFiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in thread_files (list)
        _items = []
        if self.thread_files:
            for _item_thread_files in self.thread_files:
                if _item_thread_files:
                    _items.append(_item_thread_files.to_dict())
            _dict['threadFiles'] = _items
        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['displayName'] = None

        # set to None if gcs_generation (nullable) is None
        # and model_fields_set contains the field
        if self.gcs_generation is None and "gcs_generation" in self.model_fields_set:
            _dict['gcsGeneration'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expiresAt'] = None

        # set to None if public_url (nullable) is None
        # and model_fields_set contains the field
        if self.public_url is None and "public_url" in self.model_fields_set:
            _dict['publicUrl'] = None

        # set to None if public_url_expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.public_url_expires_at is None and "public_url_expires_at" in self.model_fields_set:
            _dict['publicUrlExpiresAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of File from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "filename": obj.get("filename"),
            "displayName": obj.get("displayName"),
            "mimeType": obj.get("mimeType"),
            "size": obj.get("size"),
            "bucketName": obj.get("bucketName"),
            "gcsPath": obj.get("gcsPath"),
            "gcsGeneration": obj.get("gcsGeneration"),
            "uploadedById": obj.get("uploadedById"),
            "workspaceId": obj.get("workspaceId"),
            "description": obj.get("description"),
            "metadata": obj.get("metadata"),
            "isPublic": obj.get("isPublic"),
            "expiresAt": obj.get("expiresAt"),
            "publicUrl": obj.get("publicUrl"),
            "publicUrlExpiresAt": obj.get("publicUrlExpiresAt"),
            "uploadedBy": User.from_dict(obj["uploadedBy"]) if obj.get("uploadedBy") is not None else None,
            "workspace": Workspace.from_dict(obj["workspace"]) if obj.get("workspace") is not None else None,
            "projectFiles": [ProjectFile.from_dict(_item) for _item in obj["projectFiles"]] if obj.get("projectFiles") is not None else None,
            "threadFiles": [ThreadFile.from_dict(_item) for _item in obj["threadFiles"]] if obj.get("threadFiles") is not None else None
        })
        return _obj

from keplar_api.models.project_file import ProjectFile
from keplar_api.models.thread_file import ThreadFile
from keplar_api.models.user import User
from keplar_api.models.workspace import Workspace
# TODO: Rewrite to not use raise_errors
File.model_rebuild(raise_errors=False)

