# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.code_invite_config import CodeInviteConfig
from keplar_api.models.invite_status import InviteStatus
from keplar_api.models.join_code_invite302_response_settings import JoinCodeInvite302ResponseSettings
from typing import Optional, Set
from typing_extensions import Self

class GetCodeInvite200Response(BaseModel):
    """
    GetCodeInvite200Response
    """ # noqa: E501
    id: StrictStr
    code: StrictStr
    name: StrictStr
    description: Optional[StrictStr] = None
    status: InviteStatus
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    project_id: StrictStr = Field(alias="projectId")
    config: CodeInviteConfig
    settings: JoinCodeInvite302ResponseSettings
    __properties: ClassVar[List[str]] = ["id", "code", "name", "description", "status", "expiresAt", "projectId", "config", "settings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCodeInvite200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expiresAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCodeInvite200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "status": obj.get("status"),
            "expiresAt": obj.get("expiresAt"),
            "projectId": obj.get("projectId"),
            "config": CodeInviteConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "settings": JoinCodeInvite302ResponseSettings.from_dict(obj["settings"]) if obj.get("settings") is not None else None
        })
        return _obj


