# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from keplar_api.models.invite_config import InviteConfig
from keplar_api.models.invite_status import InviteStatus
from typing import Optional, Set
from typing_extensions import Self

class Invite(BaseModel):
    """
    Invite
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    description: Optional[StrictStr] = None
    config: InviteConfig
    code: StrictStr
    status: InviteStatus
    created_at: datetime = Field(alias="createdAt")
    updated_at: datetime = Field(alias="updatedAt")
    live_at: Optional[datetime] = Field(default=None, alias="liveAt")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    created_by_id: StrictStr = Field(alias="createdById")
    project_id: StrictStr = Field(alias="projectId")
    created_by: Optional[User] = Field(default=None, alias="createdBy")
    project: Optional[Project] = None
    calls: Optional[List[Call]] = None
    participant_invites: Optional[List[ParticipantInvite]] = Field(default=None, alias="participantInvites")
    invite_responses: Optional[List[InviteResponse]] = Field(default=None, alias="inviteResponses")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "config", "code", "status", "createdAt", "updatedAt", "liveAt", "expiresAt", "createdById", "projectId", "createdBy", "project", "calls", "participantInvites", "inviteResponses"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Invite from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in calls (list)
        _items = []
        if self.calls:
            for _item_calls in self.calls:
                if _item_calls:
                    _items.append(_item_calls.to_dict())
            _dict['calls'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in participant_invites (list)
        _items = []
        if self.participant_invites:
            for _item_participant_invites in self.participant_invites:
                if _item_participant_invites:
                    _items.append(_item_participant_invites.to_dict())
            _dict['participantInvites'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invite_responses (list)
        _items = []
        if self.invite_responses:
            for _item_invite_responses in self.invite_responses:
                if _item_invite_responses:
                    _items.append(_item_invite_responses.to_dict())
            _dict['inviteResponses'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if live_at (nullable) is None
        # and model_fields_set contains the field
        if self.live_at is None and "live_at" in self.model_fields_set:
            _dict['liveAt'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expiresAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Invite from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "config": InviteConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "code": obj.get("code"),
            "status": obj.get("status"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "liveAt": obj.get("liveAt"),
            "expiresAt": obj.get("expiresAt"),
            "createdById": obj.get("createdById"),
            "projectId": obj.get("projectId"),
            "createdBy": User.from_dict(obj["createdBy"]) if obj.get("createdBy") is not None else None,
            "project": Project.from_dict(obj["project"]) if obj.get("project") is not None else None,
            "calls": [Call.from_dict(_item) for _item in obj["calls"]] if obj.get("calls") is not None else None,
            "participantInvites": [ParticipantInvite.from_dict(_item) for _item in obj["participantInvites"]] if obj.get("participantInvites") is not None else None,
            "inviteResponses": [InviteResponse.from_dict(_item) for _item in obj["inviteResponses"]] if obj.get("inviteResponses") is not None else None
        })
        return _obj

from keplar_api.models.call import Call
from keplar_api.models.invite_response import InviteResponse
from keplar_api.models.participant_invite import ParticipantInvite
from keplar_api.models.project import Project
from keplar_api.models.user import User
# TODO: Rewrite to not use raise_errors
Invite.model_rebuild(raise_errors=False)

