# coding: utf-8

"""
    Fastify Template API

    API documentation using Swagger

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from keplar_api.models.invite_config_byo_panel import InviteConfigByoPanel
from keplar_api.models.invite_config_contacts import InviteConfigContacts
from keplar_api.models.invite_config_keplar_panel import InviteConfigKeplarPanel
from keplar_api.models.invite_config_public import InviteConfigPublic
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

INVITECONFIG_ONE_OF_SCHEMAS = ["InviteConfigByoPanel", "InviteConfigContacts", "InviteConfigKeplarPanel", "InviteConfigPublic"]

class InviteConfig(BaseModel):
    """
    InviteConfig
    """
    # data type: InviteConfigKeplarPanel
    oneof_schema_1_validator: Optional[InviteConfigKeplarPanel] = None
    # data type: InviteConfigContacts
    oneof_schema_2_validator: Optional[InviteConfigContacts] = None
    # data type: InviteConfigPublic
    oneof_schema_3_validator: Optional[InviteConfigPublic] = None
    # data type: InviteConfigByoPanel
    oneof_schema_4_validator: Optional[InviteConfigByoPanel] = None
    actual_instance: Optional[Union[InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic]] = None
    one_of_schemas: Set[str] = { "InviteConfigByoPanel", "InviteConfigContacts", "InviteConfigKeplarPanel", "InviteConfigPublic" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = InviteConfig.model_construct()
        error_messages = []
        match = 0
        # validate data type: InviteConfigKeplarPanel
        if not isinstance(v, InviteConfigKeplarPanel):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InviteConfigKeplarPanel`")
        else:
            match += 1
        # validate data type: InviteConfigContacts
        if not isinstance(v, InviteConfigContacts):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InviteConfigContacts`")
        else:
            match += 1
        # validate data type: InviteConfigPublic
        if not isinstance(v, InviteConfigPublic):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InviteConfigPublic`")
        else:
            match += 1
        # validate data type: InviteConfigByoPanel
        if not isinstance(v, InviteConfigByoPanel):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InviteConfigByoPanel`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in InviteConfig with oneOf schemas: InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in InviteConfig with oneOf schemas: InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into InviteConfigKeplarPanel
        try:
            instance.actual_instance = InviteConfigKeplarPanel.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InviteConfigContacts
        try:
            instance.actual_instance = InviteConfigContacts.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InviteConfigPublic
        try:
            instance.actual_instance = InviteConfigPublic.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InviteConfigByoPanel
        try:
            instance.actual_instance = InviteConfigByoPanel.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into InviteConfig with oneOf schemas: InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InviteConfig with oneOf schemas: InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], InviteConfigByoPanel, InviteConfigContacts, InviteConfigKeplarPanel, InviteConfigPublic]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


